/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.settings.GuiListScreen;
import org.vivecraft.client.gui.widgets.SettingsList;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class GuiBlacklistEditor
extends GuiListScreen {
    private List<String> elements;

    public GuiBlacklistEditor(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"vivecraft.options.screen.blocklist"), lastScreen);
    }

    @Override
    protected void m_7856_() {
        this.m_169413_();
        double scrollAmount = this.list != null ? this.list.m_93517_() : 0.0;
        this.list = new SettingsList(this, this.f_96541_, this.getEntries());
        this.list.m_93410_(scrollAmount);
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), button -> {
            ClientDataHolderVR.getInstance().vrSettings.vrServerBlacklist = ClientDataHolderVR.getInstance().vrSettings.getServerBlacklistDefault();
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
            this.elements = null;
            this.reinit = true;
        }).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 27, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 150, 20).m_253136_());
    }

    @Override
    public void m_7379_() {
        ClientDataHolderVR.getInstance().vrSettings.vrServerBlacklist = this.elements.toArray(new String[0]);
        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        super.m_7379_();
    }

    private List<String> getCurrentValues() {
        return this.list.m_6702_().stream().map(entry -> {
            if (entry instanceof ListValueEntry) {
                ListValueEntry listValueEntry = (ListValueEntry)((Object)entry);
                return listValueEntry.getString();
            }
            return "";
        }).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<String>(Arrays.asList(ClientDataHolderVR.getInstance().vrSettings.vrServerBlacklist));
        }
        int i = 0;
        for (String item : this.elements) {
            EditBox box = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 279, 20, (Component)Component.m_237113_((String)item));
            box.m_94199_(1000);
            box.m_94144_(item);
            int index = i++;
            box.m_94151_(s -> this.elements.set(index, (String)s));
            entries.add(new ListValueEntry((Component)Component.m_237119_(), box, button -> {
                this.elements.remove(index);
                this.reinit = true;
            }));
        }
        entries.add(new SettingsList.WidgetEntry((Component)Component.m_237115_((String)"vivecraft.options.addnew"), (AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
            this.elements = this.getCurrentValues();
            this.elements.add("");
            this.reinit = true;
        }).m_253046_(20, 20).m_253136_()));
        return entries;
    }

    private static class ListValueEntry
    extends SettingsList.WidgetEntry {
        public static final int valueButtonWidth = 280;
        private final Button deleteButton;

        public ListValueEntry(Component name, EditBox valueWidget, Button.OnPress deleteAction) {
            super(name, (AbstractWidget)valueWidget);
            this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), (Button.OnPress)deleteAction).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.delete"))).m_252987_(0, 0, 20, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.valueWidget.m_252865_(left + -50);
            this.valueWidget.m_253211_(top);
            this.valueWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.m_252865_(left + 230);
            this.deleteButton.m_253211_(top);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.deleteButton);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.deleteButton);
        }

        public String getString() {
            return ((EditBox)this.valueWidget).m_94155_();
        }
    }
}

