/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.phys.Vec2;
import org.vivecraft.client.gui.framework.GuiVROption;
import org.vivecraft.client.gui.framework.GuiVROptionButton;
import org.vivecraft.client.gui.framework.GuiVROptionSlider;
import org.vivecraft.client.gui.framework.VROptionEntry;
import org.vivecraft.client.gui.framework.VROptionLayout;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public abstract class GuiVROptionsBase
extends Screen {
    protected ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
    protected final Screen lastScreen;
    protected final VRSettings vrSettings;
    protected boolean reinit;
    protected boolean drawDefaultButtons = true;
    protected ObjectSelectionList visibleList = null;
    private int nextButtonIndex = 0;
    public String vrTitle = "Title";
    private Button btnDone;
    private Button btnDefaults;

    public GuiVROptionsBase(Screen lastScreen) {
        super((Component)Component.m_237113_((String)""));
        this.lastScreen = lastScreen;
        this.vrSettings = ClientDataHolderVR.getInstance().vrSettings;
    }

    protected void addDefaultButtons() {
        this.btnDone = new Button.Builder((Component)Component.m_237115_((String)"gui.back"), p -> {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDone);
        this.btnDefaults = new Button.Builder((Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), p -> {
            this.loadDefaults();
            this.dataHolder.vrSettings.saveOptions();
            this.reinit = true;
        }).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDefaults);
    }

    protected boolean onDoneClicked() {
        return false;
    }

    protected void init(VROptionLayout[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
        }
        for (final VROptionLayout layout : settings) {
            if (layout.getOption() != null && layout.getOption().getEnumFloat()) {
                this.m_142416_((GuiEventListener)new GuiVROptionSlider(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getOption()){

                    public void m_5716_(double mouseX, double mouseY) {
                        if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply(this, new Vec2((float)mouseX, (float)mouseY)).booleanValue()) {
                            super.m_5716_(mouseX, mouseY);
                        }
                    }
                });
                continue;
            }
            if (layout.getOption() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getOption(), layout.getButtonText(), p -> {
                    if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                        this.vrSettings.setOptionValue(((GuiVROptionButton)p).getOption());
                        p.m_93666_((Component)Component.m_237113_((String)layout.getButtonText()));
                    }
                }));
                continue;
            }
            if (layout.getScreen() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> {
                    try {
                        if (layout.getCustomHandler() != null && layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                            return;
                        }
                        this.vrSettings.saveOptions();
                        this.f_96541_.m_91152_(layout.getScreen().getConstructor(Screen.class).newInstance(new Object[]{this}));
                    }
                    catch (ReflectiveOperationException e) {
                        VRSettings.LOGGER.error("Vivecraft: error setting screen: ", (Throwable)e);
                    }
                }));
                continue;
            }
            if (layout.getCustomHandler() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f))));
                continue;
            }
            this.m_142416_((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.f_96543_), layout.getY(this.f_96544_), layout.getButtonText(), p -> {}));
        }
    }

    protected void loadDefaults() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof GuiVROption)) continue;
            GuiVROption optionButton = (GuiVROption)child;
            this.vrSettings.loadDefault(optionButton.getOption());
        }
    }

    protected void init(VROptionEntry[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
            this.nextButtonIndex = 0;
        }
        ArrayList<VROptionLayout> layouts = new ArrayList<VROptionLayout>();
        if (this.nextButtonIndex < this.m_6702_().size()) {
            this.nextButtonIndex = this.m_6702_().size();
        }
        int nextIndex = this.nextButtonIndex;
        for (VROptionEntry setting : settings) {
            VROptionLayout.Position pos;
            VROptionLayout.Position position = setting.center ? VROptionLayout.Position.POS_CENTER : (pos = nextIndex % 2 == 0 ? VROptionLayout.Position.POS_LEFT : VROptionLayout.Position.POS_RIGHT);
            if (setting.center && nextIndex % 2 != 0) {
                ++nextIndex;
            }
            if (setting.option != null) {
                if (setting.option != VRSettings.VrOptions.DUMMY) {
                    layouts.add(new VROptionLayout(setting.option, setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
                }
            } else if (setting.customHandler != null) {
                layouts.add(new VROptionLayout(setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
            }
            if (setting.center) {
                ++nextIndex;
            }
            ++nextIndex;
        }
        this.nextButtonIndex = nextIndex;
        this.init(layouts.toArray(new VROptionLayout[0]), false);
    }

    protected void init(VRSettings.VrOptions[] settings, boolean clear) {
        VROptionEntry[] entries = new VROptionEntry[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            entries[i] = new VROptionEntry(settings[i]);
        }
        this.init(entries, clear);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            VRSettings.VrOptions vrOptions;
            this.reinit = false;
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof GuiVROption) {
                GuiVROption option = (GuiVROption)guiEventListener;
                vrOptions = option.getOption();
            } else {
                vrOptions = null;
            }
            VRSettings.VrOptions selected = vrOptions;
            this.m_7856_();
            if (selected != null) {
                GuiEventListener newButton = this.m_6702_().stream().filter(listener -> {
                    GuiVROption option;
                    return listener instanceof GuiVROption && (option = (GuiVROption)listener).getOption() == selected;
                }).findFirst().orElse(null);
                this.m_7522_(newButton);
            }
        }
        this.m_280273_(guiGraphics);
        if (this.visibleList != null) {
            this.visibleList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)this.vrTitle), this.f_96543_ / 2, 15, 0xFFFFFF);
        if (this.btnDefaults != null) {
            this.btnDefaults.f_93624_ = this.drawDefaultButtons;
        }
        if (this.btnDone != null) {
            this.btnDone.f_93624_ = this.drawDefaultButtons;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void actionPerformed(AbstractWidget widget) {
    }

    protected void actionPerformedRightClick(AbstractWidget widget) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiEventListener guiEventListener;
        boolean success = super.m_6375_(mouseX, mouseY, button);
        if (success && (guiEventListener = this.m_7222_()) instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (button == 0) {
                this.actionPerformed(widget);
            } else if (button == 1) {
                this.actionPerformedRightClick(widget);
            }
        } else if (this.visibleList != null) {
            return this.visibleList.m_6375_(mouseX, mouseY, button);
        }
        return success;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.visibleList != null ? this.visibleList.m_6348_(mouseX, mouseY, button) : super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.visibleList != null ? this.visibleList.m_7979_(mouseX, mouseY, button, dragX, dragY) : super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.visibleList != null) {
            this.visibleList.m_6050_(mouseX, mouseY, scrollY);
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                this.actionPerformed(widget);
            }
            return true;
        }
        return this.visibleList != null && this.visibleList.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.visibleList != null && this.visibleList.m_5534_(codePoint, modifiers) || super.m_5534_(codePoint, modifiers);
    }

    private void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        GuiVROption guiHover;
        GuiEventListener hover = null;
        if (this.f_96541_.m_264529_().m_264505_()) {
            hover = this.m_7222_();
        }
        if (hover == null) {
            for (GuiEventListener child : this.m_6702_()) {
                AbstractWidget widget;
                if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, mouseX, mouseY)) continue;
                hover = child;
            }
        }
        if (hover != null && hover instanceof GuiVROption && (guiHover = (GuiVROption)hover).getOption() != null) {
            String tooltipString = "vivecraft.options." + guiHover.getOption().name() + ".tooltip";
            Object tooltip = "";
            if (I18n.m_118936_((String)tooltipString)) {
                tooltip = I18n.m_118938_((String)tooltipString, (Object[])new Object[]{null});
            }
            if (this.dataHolder.vrSettings.overrides.hasSetting(guiHover.getOption())) {
                VRSettings.ServerOverrides.Setting setting = this.dataHolder.vrSettings.overrides.getSetting(guiHover.getOption());
                if (setting.isValueOverridden()) {
                    tooltip = I18n.m_118938_((String)"vivecraft.message.overriddenbyserver", (Object[])new Object[0]) + (String)tooltip;
                } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                    tooltip = I18n.m_118938_((String)"vivecraft.message.limitedbyserver", (Object[])new Object[]{Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())}) + (String)tooltip;
                }
            }
            if (!((String)tooltip).isEmpty()) {
                tooltip = ((String)tooltip).replace("\n", "\u00a7r\n");
                List formattedText = this.f_96547_.m_92865_().m_92432_((String)tooltip, 308, Style.f_131099_);
                tooltip = (String)tooltip + " ".repeat((308 - (formattedText.isEmpty() ? 0 : this.f_96547_.m_92852_((FormattedText)formattedText.get(formattedText.size() - 1)))) / this.f_96547_.m_92895_(" "));
                int n = guiHover.m_252907_() + guiHover.m_93694_();
                int n2 = formattedText.size();
                Objects.requireNonNull(this.f_96547_);
                if (n + n2 * (9 + 1) + 14 < this.f_96544_) {
                    guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308), this.f_96543_ / 2 - 166, guiHover.m_252907_() + guiHover.m_93694_() + 14);
                } else {
                    List list = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308);
                    int n3 = this.f_96543_ / 2 - 166;
                    int n4 = guiHover.m_252907_();
                    int n5 = formattedText.size();
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280245_(this.f_96547_, list, n3, n4 - n5 * (9 + 1) + 9);
                }
            }
        }
    }

    private boolean isMouseOver(AbstractWidget widget, double mouseX, double mouseY) {
        return widget.f_93624_ && mouseX >= (double)widget.m_252754_() && mouseY >= (double)widget.m_252907_() && mouseX < (double)(widget.m_252754_() + widget.m_5711_()) && mouseY < (double)(widget.m_252907_() + widget.m_93694_());
    }
}

