/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.sounds;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.ISandstormClientDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.SandstormClientData;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.SoundModule;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.BiomeManager;

public class LostCavesAmbientSoundsHandler
implements AmbientSoundHandler {
    private static final ResourceLocation regularAmbientSound = YungsCaveBiomesCommon.id("ambient.lost_caves.loop");
    private static final ResourceLocation sandstormAmbientSound = YungsCaveBiomesCommon.id("ambient.lost_caves.sandstorm_loop");
    private final LocalPlayer player;
    private final SoundManager soundManager;
    private final BiomeManager biomeManager;
    private BiomeAmbientSoundsHandler.LoopSoundInstance lostCavesSound = new BiomeAmbientSoundsHandler.LoopSoundInstance((SoundEvent)SoundModule.AMBIENT_LOST_CAVES.get());
    private boolean inLostCaves = false;

    public LostCavesAmbientSoundsHandler(LocalPlayer localPlayer, SoundManager soundManager, BiomeManager biomeManager) {
        this.player = localPlayer;
        this.soundManager = soundManager;
        this.biomeManager = biomeManager;
    }

    public void m_7551_() {
        Holder currBiome;
        if (!this.player.m_6084_() && this.lostCavesSound != null) {
            this.lostCavesSound.m_119659_();
        }
        if ((currBiome = this.biomeManager.m_204206_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_())).m_203565_(BiomeModule.LOST_CAVES) && !this.inLostCaves) {
            this.inLostCaves = true;
            this.changeAmbientsound((SoundEvent)SoundModule.AMBIENT_LOST_CAVES.get());
        }
        if (!currBiome.m_203565_(BiomeModule.LOST_CAVES)) {
            this.inLostCaves = false;
            this.lostCavesSound.m_119659_();
        }
        SandstormClientData sandstormClientData = ((ISandstormClientDataProvider)this.player.m_9236_()).getSandstormClientData();
        if (this.inLostCaves) {
            if (sandstormClientData.isSandstormActive() && !this.lostCavesSound.m_7904_().equals((Object)sandstormAmbientSound)) {
                this.changeAmbientsound((SoundEvent)SoundModule.SANDSTORM_AMBIENT_LOST_CAVES.get());
            }
            if (!sandstormClientData.isSandstormActive() && !this.lostCavesSound.m_7904_().equals((Object)regularAmbientSound)) {
                this.changeAmbientsound((SoundEvent)SoundModule.AMBIENT_LOST_CAVES.get());
            }
        }
    }

    private void changeAmbientsound(SoundEvent newAmbientSoundEvent) {
        if (this.lostCavesSound != null) {
            this.lostCavesSound.m_119659_();
        }
        this.lostCavesSound = new BiomeAmbientSoundsHandler.LoopSoundInstance(newAmbientSoundEvent);
        this.soundManager.m_120367_((SoundInstance)this.lostCavesSound);
        this.lostCavesSound.m_119660_();
    }
}

