/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.common.mixinutils.ChatName;
import net.smileycorp.hordes.common.mixinutils.CustomTexture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements CustomTexture {
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public MixinLivingEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture.toString());
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(TEXTURE));
    }

    @Override
    public boolean hasCustomTexture() {
        return !((String)this.f_19804_.m_135370_(TEXTURE)).isEmpty();
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    public void defineSynchedData(CallbackInfo callback) {
        this.f_19804_.m_135372_(TEXTURE, (Object)"");
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        if (this.hasCustomTexture()) {
            tag.m_128359_("texture", (String)this.f_19804_.m_135370_(TEXTURE));
        }
        if (((ChatName)((Object)this)).hasChatName()) {
            tag.m_128359_("chat_name", ((ChatName)((Object)this)).getChatName());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        String texture;
        if (tag.m_128441_("texture") && ResourceLocation.m_135830_((String)(texture = tag.m_128461_("texture")))) {
            this.f_19804_.m_135381_(TEXTURE, (Object)texture);
        }
        if (tag.m_128441_("chat_name")) {
            ((ChatName)((Object)this)).setChatName(tag.m_128461_("chat_name"));
        }
    }
}

