/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.capability.ZombifyPlayer;
import net.smileycorp.hordes.infection.HordesInfection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DamageSource.class})
public class MixinDamageSource {
    @Inject(at={@At(value="HEAD")}, method={"getLocalizedDeathMessage"}, cancellable=true)
    public void getLocalizedDeathMessage(LivingEntity entity, CallbackInfoReturnable<Component> callback) {
        if (!(entity instanceof Player) || !this.equals(HordesInfection.getInfectionDamage(entity))) {
            return;
        }
        Object msg = "death.attack.infection";
        LazyOptional optional = entity.getCapability(HordesCapabilities.ZOMBIFY_PLAYER);
        if (optional.isPresent() && ((ZombifyPlayer)optional.orElseGet(null)).wasZombified()) {
            msg = (String)msg + ".zombified";
        }
        callback.setReturnValue((Object)Component.m_237110_((String)msg, (Object[])new Object[]{entity.m_5446_()}));
    }
}

