/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.data;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.util.Func;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.DataRegistry;
import net.smileycorp.hordes.infection.data.InfectionDataLoader;

public class InfectionConversionEntry {
    protected final EntityType<? extends Mob> entity;
    protected final EntityType<? extends Mob> result;
    protected final float infectChance;
    protected final CompoundTag nbt;

    private InfectionConversionEntry(EntityType<? extends Mob> entity, EntityType<? extends Mob> result, float infectChance, CompoundTag nbt) {
        if (entity == null || result == null) {
            throw new NullPointerException();
        }
        this.entity = entity;
        this.result = result;
        this.infectChance = infectChance;
        this.nbt = nbt;
        HordesLogger.logInfo("Loaded conversion " + entity + " to " + result + (nbt != null ? nbt : "") + " with chance of " + infectChance);
    }

    public LivingEntity convertEntity(Mob entity) {
        LivingConversionEvent.Pre preEvent = new LivingConversionEvent.Pre((LivingEntity)entity, this.result, xva$0 -> Func.Void((Object[])new Object[]{xva$0}));
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        Mob zombie = entity.m_21406_(this.result, true);
        if (zombie instanceof AgeableMob) {
            ((AgeableMob)zombie).m_146762_(entity.m_6162_() ? -1000000 : 0);
        }
        if (zombie instanceof Zombie) {
            ((Zombie)zombie).m_6863_(entity.m_6162_());
        }
        if (this.nbt != null) {
            zombie.m_7378_(this.nbt);
        }
        LivingConversionEvent.Post postEvent = new LivingConversionEvent.Post((LivingEntity)entity, (LivingEntity)zombie);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        return zombie;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public boolean shouldInfect(LivingEntity entity) {
        return entity.m_217043_().m_188501_() <= InfectionDataLoader.INSTANCE.getModifiedInfectChance(entity, this.infectChance);
    }

    public static InfectionConversionEntry deserialize(JsonObject json) throws Exception {
        EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("entity").getAsString()));
        EntityType converts_to = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("converts_to").getAsString()));
        float chance = json.get("chance").getAsFloat();
        CompoundTag nbt = json.has("nbt") ? DataRegistry.parseNBT(entity.m_147048_(), json.get("nbt").getAsString()) : null;
        return new InfectionConversionEntry((EntityType<? extends Mob>)entity, (EntityType<? extends Mob>)converts_to, chance, nbt);
    }
}

