/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.capability.Infection;
import net.smileycorp.hordes.infection.network.InfectMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;

public class InfectedEffect
extends MobEffect {
    private final UUID SPEED_MOD_UUID = UUID.fromString("05d68949-cb8b-4031-92a6-bd75e42b5cdd");
    private final String SPEED_MOD_NAME = Constants.name("Infected");
    private final AttributeModifier SPEED_MOD = new AttributeModifier(this.SPEED_MOD_NAME, -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public InfectedEffect() {
        super(MobEffectCategory.HARMFUL, 0x440002);
    }

    public List<ItemStack> getCurativeItems() {
        return (Boolean)InfectionConfig.enableMobInfection.get() != false ? HordesInfection.getCureList() : super.getCurativeItems();
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            ((Player)entity).m_36399_(0.03f * (float)(amplifier + 1));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return (Boolean)InfectionConfig.infectHunger.get();
    }

    public void m_6385_(LivingEntity entity, AttributeMap map, int amplifier) {
        if (amplifier < 0 | (Boolean)InfectionConfig.infectSlowness.get() == false) {
            return;
        }
        AttributeInstance attribute = map.m_22146_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        attribute.m_22120_(this.SPEED_MOD_UUID);
        attribute.m_22125_(new AttributeModifier(this.SPEED_MOD_UUID, this.SPEED_MOD_NAME + " " + amplifier, this.m_7048_(amplifier - 1, this.SPEED_MOD), AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public void m_6386_(LivingEntity entity, AttributeMap map, int amplifier) {
        AttributeInstance attribute = map.m_22146_(Attributes.f_22279_);
        if (attribute != null) {
            attribute.m_22120_(this.SPEED_MOD_UUID);
        }
    }

    public static void apply(LivingEntity entity) {
        boolean prevented = InfectedEffect.preventInfection(entity);
        if (entity instanceof ServerPlayer) {
            InfectionPacketHandler.sendTo(new InfectMessage(prevented), ((ServerPlayer)entity).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        if (!prevented) {
            entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), InfectedEffect.getInfectionTime(entity)));
        }
    }

    public static boolean preventInfection(LivingEntity entity) {
        return entity.m_21023_((MobEffect)HordesInfection.IMMUNITY.get());
    }

    public static int getInfectionTime(LivingEntity entity) {
        int time = (Integer)InfectionConfig.ticksForEffectStage.get();
        LazyOptional optional = entity.getCapability(HordesCapabilities.INFECTION);
        if (optional.isPresent()) {
            time = (int)((double)time * Math.pow((Double)InfectionConfig.effectStageTickReduction.get(), ((Infection)optional.orElseGet(null)).getInfectionCount()));
        }
        return time;
    }
}

