/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.network;

import java.io.Serializable;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.smileycorp.atlas.api.network.AbstractMessage;
import net.smileycorp.atlas.api.network.GenericStringMessage;
import net.smileycorp.atlas.api.network.NetworkUtils;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.network.HordeSoundMessage;
import net.smileycorp.hordes.hordeevent.network.UpdateClientHordeMessage;

public class HordeEventPacketHandler {
    private static SimpleChannel NETWORK_INSTANCE;

    public static void sendTo(AbstractMessage message, Connection manager, NetworkDirection direction) {
        if (!((Boolean)HordeEventConfig.enableHordeEvent.get()).booleanValue()) {
            return;
        }
        NETWORK_INSTANCE.sendTo((Object)message, manager, direction);
    }

    public static void send(PacketDistributor.PacketTarget target, AbstractMessage message) {
        if (!((Boolean)HordeEventConfig.enableHordeEvent.get()).booleanValue()) {
            return;
        }
        NETWORK_INSTANCE.send(target, (Object)message);
    }

    public static void initPackets() {
        NETWORK_INSTANCE = NetworkUtils.createChannel((ResourceLocation)Constants.loc("HordeEvent"));
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)0, HordeSoundMessage.class);
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)1, GenericStringMessage.class, HordeEventPacketHandler::processNotificationMessage);
        NetworkUtils.registerMessage((SimpleChannel)NETWORK_INSTANCE, (int)2, UpdateClientHordeMessage.class);
    }

    public static void processNotificationMessage(GenericStringMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.displayMessage(message.getText())));
        ctx.get().setPacketHandled(true);
    }
}

