/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.hordeevent.HordeSpawnType;
import net.smileycorp.hordes.hordeevent.HordeSpawnTypes;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;

public class HordeSpawnData {
    private HordeSpawnTable table = HordeTableLoader.INSTANCE.getFallbackTable();
    private HordeSpawnType spawnType = HordeSpawnTypes.AVOID_FLUIDS;
    private ResourceLocation spawnSound = Constants.HORDE_SOUND;
    private String startMessage = "message.hordes.EventStart";
    private String endMessage = "message.hordes.EventEnd";
    private int spawnDuration = (Integer)HordeEventConfig.hordeSpawnDuration.get();
    private int spawnInterval = (Integer)HordeEventConfig.hordeSpawnInterval.get();
    private int spawnAmount;
    private double entitySpeed = (Double)HordeEventConfig.hordeEntitySpeed.get();

    public HordeSpawnData(HordeEvent horde) {
        this.spawnAmount = (int)((double)((Integer)HordeEventConfig.hordeSpawnAmount.get()).intValue() * (1.0 + (double)(horde.getDay() / (Integer)HordeEventConfig.hordeSpawnDays.get()) * ((Double)HordeEventConfig.hordeSpawnMultiplier.get() - 1.0)));
    }

    public HordeSpawnData(HordeEvent horde, CompoundTag tag) {
        this(horde);
        if (tag.m_128441_("table")) {
            this.table = HordeTableLoader.INSTANCE.getTable(new ResourceLocation(tag.m_128461_("table")));
        }
        if (tag.m_128441_("spawnType")) {
            this.spawnType = HordeSpawnTypes.fromNBT(tag.m_128423_("spawnType"));
        }
        if (tag.m_128441_("spawnSound")) {
            this.spawnSound = new ResourceLocation(tag.m_128461_("spawnSound"));
        }
        if (tag.m_128441_("startMessage")) {
            this.startMessage = tag.m_128461_("startMessage");
        }
        if (tag.m_128441_("endMessage")) {
            this.endMessage = tag.m_128461_("endMessage");
        }
        if (tag.m_128441_("spawnDuration")) {
            this.spawnDuration = tag.m_128451_("spawnDuration");
        }
        if (tag.m_128441_("spawnInterval")) {
            this.spawnInterval = tag.m_128451_("spawnInterval");
        }
        if (tag.m_128441_("spawnAmount")) {
            this.spawnAmount = tag.m_128451_("spawnAmount");
        }
        if (tag.m_128441_("entitySpeed")) {
            this.entitySpeed = tag.m_128459_("entitySpeed");
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.table != null) {
            tag.m_128359_("table", this.table.getName().toString());
        }
        if (this.spawnType != null) {
            tag.m_128365_("spawnType", HordeSpawnTypes.toNbt(this.spawnType));
        }
        if (this.spawnSound != null) {
            tag.m_128359_("spawnSound", this.spawnSound.toString());
        }
        if (this.startMessage != null) {
            tag.m_128359_("startMessage", this.startMessage);
        }
        if (this.endMessage != null) {
            tag.m_128359_("endMessage", this.endMessage);
        }
        tag.m_128405_("spawnDuration", this.spawnDuration);
        tag.m_128405_("spawnInterval", this.spawnInterval);
        tag.m_128405_("spawnAmount", this.spawnAmount);
        tag.m_128347_("entitySpeed", this.entitySpeed);
        return tag;
    }

    public HordeSpawnTable getTable() {
        return this.table;
    }

    public void setTable(HordeSpawnTable table) {
        this.table = table;
    }

    public HordeSpawnType getSpawnType() {
        return this.spawnType;
    }

    public void setSpawnType(HordeSpawnType spawnType) {
        this.spawnType = spawnType;
    }

    public ResourceLocation getSpawnSound() {
        return this.spawnSound;
    }

    public void setSpawnSound(ResourceLocation spawnSound) {
        this.spawnSound = spawnSound;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public void setEndMessage(String endMessage) {
        this.endMessage = endMessage;
    }

    public int getSpawnDuration() {
        return this.spawnDuration;
    }

    public void setSpawnDuration(int spawnDuration) {
        this.spawnDuration = spawnDuration;
    }

    public int getSpawnInterval() {
        return this.spawnInterval;
    }

    public void setSpawnInterval(int spawnInterval) {
        this.spawnInterval = spawnInterval;
    }

    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    public double getEntitySpeed() {
        return this.entitySpeed;
    }

    public void setEntitySpeed(double entitySpeed) {
        this.entitySpeed = entitySpeed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "[");
        builder.append("table=" + this.table.getName() + ", ");
        builder.append("spawnType=" + HordeSpawnTypes.toString(this.spawnType) + ", ");
        builder.append("spawnSound=" + this.spawnSound + ", ");
        builder.append("startMessage=" + this.startMessage + ", ");
        builder.append("endMessage=" + this.endMessage + ", ");
        builder.append("spawnDuration=" + this.spawnDuration + ", ");
        builder.append("spawnInterval=" + this.spawnInterval + ", ");
        builder.append("spawnAmount=" + this.spawnAmount + ", ");
        builder.append("entitySpeed=" + this.entitySpeed + "]");
        return builder.toString();
    }
}

