/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.conditions;

import com.google.gson.JsonElement;
import java.util.UUID;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.data.values.ValueGetter;

public class GameStagesCondition
implements Condition {
    protected ValueGetter<String> stage;

    public GameStagesCondition(ValueGetter<String> stage) {
        this.stage = stage;
    }

    @Override
    public boolean apply(Level level, LivingEntity entity, ServerPlayer player, RandomSource rand) {
        return GameStageSaveHandler.getPlayerData((UUID)player.m_20148_()).hasStage(this.stage.get(level, entity, player, rand));
    }

    public static GameStagesCondition deserialize(JsonElement json) {
        try {
            return new GameStagesCondition(ValueGetter.readValue(DataType.STRING, json));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition gamestages:gamestage", e);
            return null;
        }
    }
}

