/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.cclayer.CCLayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.capability.ItemizedCurioCapability;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.WrappedAccessory;
import top.theillusivec4.curios.compat.WrappedCurio;
import top.theillusivec4.curios.compat.WrappedCurioItemHandler;

public class CuriosImplMixinHooks {
    public static final Map<Item, ICurioItem> REGISTRY = new ConcurrentHashMap<Item, ICurioItem>();
    private static final Map<String, UUID> UUIDS = new HashMap<String, UUID>();
    private static final Map<ResourceLocation, Predicate<SlotResult>> SLOT_RESULT_PREDICATES = new HashMap<ResourceLocation, Predicate<SlotResult>>();

    public static void registerCurio(Item item, ICurioItem icurio) {
        REGISTRY.put(item, icurio);
        AccessoriesAPI.registerAccessory((Item)item, (Accessory)new WrappedCurio(icurio));
    }

    public static Optional<ICurioItem> getCurioFromRegistry(Item item) {
        ICurioItem iCurioItem = REGISTRY.get(item);
        if (iCurioItem != null) {
            return Optional.of(iCurioItem);
        }
        return Optional.of(new WrappedAccessory(AccessoriesAPI.getOrDefaultAccessory((Item)item)));
    }

    public static Optional<ISlotType> getSlot(String id) {
        return Optional.ofNullable(CuriosApi.getSlots().get(id));
    }

    public static ResourceLocation getSlotIcon(String id) {
        SlotType type = (SlotType)SlotTypeLoader.INSTANCE.getSlotTypes(false).get(CuriosWrappingUtils.curiosToAccessories(id));
        if (type == null) {
            return new ResourceLocation("curios", "slot/empty_curio_slot");
        }
        return type.icon();
    }

    public static Map<String, ISlotType> getSlots(boolean isClient) {
        return (isClient ? CuriosSlotManager.CLIENT : CuriosSlotManager.SERVER).getSlots();
    }

    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type, boolean isClient) {
        return (isClient ? CuriosEntityManager.SERVER : CuriosEntityManager.CLIENT).getEntitySlots(type);
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, boolean isClient) {
        Level level = CCLayer.getDummyLevel(isClient);
        return CuriosImplMixinHooks.filteredSlots(slotType -> {
            SlotContext slotContext = new SlotContext(slotType.getIdentifier(), null, 0, false, true);
            CursedSlotResult slotResult = new CursedSlotResult(slotContext, stack, level);
            return CuriosApi.testCurioPredicates(slotType.getValidators(), slotResult);
        }, CuriosApi.getSlots(isClient));
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, LivingEntity livingEntity) {
        return CuriosImplMixinHooks.filteredSlots(slotType -> {
            SlotContext slotContext = new SlotContext(slotType.getIdentifier(), livingEntity, 0, false, true);
            SlotResult slotResult = new SlotResult(slotContext, stack);
            return CuriosApi.testCurioPredicates(slotType.getValidators(), slotResult);
        }, CuriosApi.getEntitySlots(livingEntity));
    }

    private static Map<String, ISlotType> filteredSlots(Predicate<ISlotType> filter, Map<String, ISlotType> map) {
        HashMap<String, ISlotType> result = new HashMap<String, ISlotType>();
        for (Map.Entry<String, ISlotType> entry : map.entrySet()) {
            ISlotType slotType = entry.getValue();
            if (!filter.test(slotType)) continue;
            result.put(entry.getKey(), slotType);
        }
        return result;
    }

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        LazyOptional capability = stack.getCapability(CuriosCapability.ITEM);
        if (capability.isPresent()) {
            return capability;
        }
        ICurioItem registeredCurio = REGISTRY.get(stack.m_41720_());
        if (registeredCurio == null) {
            registeredCurio = new WrappedAccessory(AccessoriesAPI.getOrDefaultAccessory((ItemStack)stack));
        }
        ItemizedCurioCapability itemizedCurio = new ItemizedCurioCapability(registeredCurio, stack);
        return LazyOptional.of(() -> itemizedCurio);
    }

    public static LazyOptional<ICuriosItemHandler> getCuriosInventory(LivingEntity livingEntity) {
        AccessoriesCapabilityImpl accessoryCapability = (AccessoriesCapabilityImpl)livingEntity.accessoriesCapability();
        if (accessoryCapability != null) {
            return LazyOptional.of(() -> new WrappedCurioItemHandler(() -> accessoryCapability));
        }
        return LazyOptional.empty();
    }

    public static boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String slotName = CuriosWrappingUtils.curiosToAccessories(slotContext.identifier());
        if (slotContext.entity() == null) {
            SlotType slotType = (SlotType)SlotTypeLoader.INSTANCE.getSlotTypes(false).get(slotName);
            if (slotType == null) {
                return false;
            }
            boolean bl = false;
            try {
                Level level = CCLayer.getDummyLevel(false);
                bl = AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (Level)level, (SlotType)slotType, (int)0, (ItemStack)stack);
            }
            catch (Exception level) {
                // empty catch block
            }
            if (!bl) {
                return false;
            }
            boolean bl2 = false;
            try {
                bl2 = AccessoriesAPI.canEquip((ItemStack)stack, (SlotReference)SlotReference.of(null, (String)slotName, (int)0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) {
                return true;
            }
        } else {
            boolean isValid = AccessoriesAPI.canInsertIntoSlot((ItemStack)stack, (SlotReference)SlotReference.of((LivingEntity)slotContext.entity(), (String)slotName, (int)slotContext.index()));
            if (isValid) {
                return true;
            }
        }
        String id = slotContext.identifier();
        Set<String> slots = CuriosImplMixinHooks.getItemStackSlots(stack, slotContext.entity()).keySet();
        return !slots.isEmpty() && id.equals("curio") || slots.contains(id) || slots.contains("curio");
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("CurioAttributeModifiers", 9)) {
            ListTag listnbt = stack.m_41783_().m_128437_("CurioAttributeModifiers", 10);
            String identifier = slotContext.identifier();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                if (!compoundnbt.m_128461_("Slot").equals(identifier)) continue;
                ResourceLocation rl = ResourceLocation.m_135820_((String)compoundnbt.m_128461_("AttributeName"));
                UUID id = uuid;
                if (rl == null) continue;
                if (compoundnbt.m_128441_("UUID")) {
                    id = compoundnbt.m_128342_("UUID");
                }
                if (id.getLeastSignificantBits() == 0L || id.getMostSignificantBits() == 0L) continue;
                AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)compoundnbt.m_128451_("Operation"));
                double amount = compoundnbt.m_128459_("Amount");
                String name = compoundnbt.m_128461_("Name");
                if (rl.m_135827_().equals("curios")) {
                    String identifier1 = CuriosWrappingUtils.curiosToAccessories(rl.m_135815_());
                    if (!CuriosApi.getSlot(identifier1).isPresent()) continue;
                    CuriosApi.addSlotModifier((Multimap<Attribute, AttributeModifier>)multimap, identifier1, id, amount, operation);
                    continue;
                }
                Attribute attribute = BuiltInRegistries.f_256951_.m_6612_(rl).orElse(null);
                if (attribute == null) continue;
                multimap.put((Object)attribute, (Object)new AttributeModifier(id, name, amount, operation));
            }
        } else {
            multimap = (Multimap)CuriosImplMixinHooks.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, uuid)).orElse(multimap);
        }
        CurioAttributeModifierEvent evt = new CurioAttributeModifierEvent(stack, slotContext, uuid, (Multimap<Attribute, AttributeModifier>)multimap);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return HashMultimap.create(evt.getModifiers());
    }

    public static void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        map.put((Object)SlotAttribute.getSlotAttribute((String)CuriosWrappingUtils.curiosToAccessories(identifier)), (Object)new AttributeModifier(uuid, identifier, amount, operation));
    }

    public static void addSlotModifier(ItemStack stack, String identifier, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        SlotAttribute.addSlotAttribute((ItemStack)stack, (String)CuriosWrappingUtils.curiosToAccessories(identifier), (String)slot, (String)name, (UUID)uuid, (double)amount, (AttributeModifier.Operation)operation, (boolean)false);
    }

    public static void addModifier(ItemStack stack, Attribute attribute, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        AccessoriesAPI.addAttribute((ItemStack)stack, (String)slot, (Attribute)attribute, (String)name, (UUID)uuid, (double)amount, (AttributeModifier.Operation)operation, (boolean)false);
    }

    public static void broadcastCurioBreakEvent(SlotContext slotContext) {
        AccessoriesAPI.breakStack((SlotReference)CuriosWrappingUtils.fromContext(slotContext));
    }

    public static UUID getUuid(SlotContext slotContext) {
        String key = slotContext.identifier() + slotContext.index();
        return UUIDS.computeIfAbsent(key, k -> UUID.nameUUIDFromBytes(k.getBytes()));
    }

    public static void registerCurioPredicate(ResourceLocation resourceLocation, Predicate<SlotResult> validator) {
        SLOT_RESULT_PREDICATES.putIfAbsent(resourceLocation, validator);
        AccessoriesAPI.registerPredicate((ResourceLocation)resourceLocation, (SlotBasedPredicate)new SafeSlotBasedPredicate(resourceLocation, validator));
    }

    public static Optional<Predicate<SlotResult>> getCurioPredicate(ResourceLocation resourceLocation) {
        return Optional.ofNullable(SLOT_RESULT_PREDICATES.get(resourceLocation));
    }

    public static Map<ResourceLocation, Predicate<SlotResult>> getCurioPredicates() {
        return ImmutableMap.copyOf(SLOT_RESULT_PREDICATES);
    }

    public static boolean testCurioPredicates(Set<ResourceLocation> predicates, SlotResult slotResult) {
        Level level;
        SlotType slotType;
        HashSet<ResourceLocation> convertedSet = new HashSet<ResourceLocation>();
        for (ResourceLocation location : predicates) {
            convertedSet.add(CuriosWrappingUtils.curiosToAccessories_Validators(location));
        }
        SlotReference ref = CuriosWrappingUtils.fromContext(slotResult.slotContext());
        if (slotResult instanceof CursedSlotResult) {
            CursedSlotResult cursedSlotResult = (CursedSlotResult)slotResult;
            slotType = (SlotType)SlotTypeLoader.INSTANCE.getSlotTypes(cursedSlotResult.level.f_46443_).get(ref.slotName());
            level = cursedSlotResult.level;
        } else {
            slotType = ref.type();
            level = ref.entity().m_9236_();
        }
        if (slotType == null) {
            throw new IllegalStateException("Unable to get a SlotType using the WrappedTrinketInventory from the SlotTypeLoader! [Name: " + slotType.name() + "]");
        }
        try {
            return AccessoriesAPI.getPredicateResults(convertedSet, (Level)level, (SlotType)slotType, (int)ref.slot(), (ItemStack)slotResult.stack());
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        CuriosImplMixinHooks.registerCurioPredicate(new ResourceLocation("curios", "all"), slotResult -> true);
        CuriosImplMixinHooks.registerCurioPredicate(new ResourceLocation("curios", "none"), slotResult -> false);
        CuriosImplMixinHooks.registerCurioPredicate(new ResourceLocation("curios", "tag"), slotResult -> {
            String id = slotResult.slotContext().identifier();
            TagKey tag1 = ItemTags.create((ResourceLocation)new ResourceLocation("curios", id));
            TagKey tag2 = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "curio"));
            ItemStack stack = slotResult.stack();
            return stack.m_204117_(tag1) || stack.m_204117_(tag2);
        });
    }

    private static final class SafeSlotBasedPredicate
    implements SlotBasedPredicate {
        private static final Logger LOGGER = LogUtils.getLogger();
        private boolean hasErrored = false;
        private final ResourceLocation location;
        private final Predicate<SlotResult> curiosValidator;

        public SafeSlotBasedPredicate(ResourceLocation location, Predicate<SlotResult> curiosValidator) {
            this.location = location;
            this.curiosValidator = curiosValidator;
        }

        public TriState isValid(Level level, SlotType slotType, int slot, ItemStack stack) {
            if (this.hasErrored) {
                return TriState.DEFAULT;
            }
            try {
                return TriState.of((boolean)this.curiosValidator.test(new SlotResult(new SlotContext(slotType.name(), null, slot, false, true), stack)));
            }
            catch (Exception e) {
                this.hasErrored = true;
                LOGGER.warn("Unable to handle Curios Slot Predicate converted to Accessories Slot Predicate due to fundamental incompatibility, issues may be present with it! [Slot: {}, Predicate ID: {}]", new Object[]{slotType.name(), this.location, e});
                return TriState.DEFAULT;
            }
        }
    }

    private static class CursedSlotResult
    extends SlotResult {
        public final Level level;

        public CursedSlotResult(SlotContext slotContext, ItemStack stack, Level level) {
            super(slotContext, stack);
            this.level = level;
        }
    }
}

