/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioInventory;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.EmptyCuriosStackHandler;
import top.theillusivec4.curios.compat.WrappedCurioStackHandler;

public class WrappedCurioItemHandler
implements ICuriosItemHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<AccessoriesCapabilityImpl> capabilitySup;

    public WrappedCurioItemHandler(Supplier<AccessoriesCapabilityImpl> capabilitySup) {
        this.capabilitySup = capabilitySup;
    }

    public Optional<AccessoriesCapabilityImpl> capability() {
        AccessoriesCapabilityImpl capability = this.capabilitySup.get();
        LazyOptional cap = capability.entity().getCapability(CuriosCapability.INVENTORY);
        return Optional.ofNullable(capability);
    }

    public static void attemptConversion(Supplier<AccessoriesCapabilityImpl> capability) {
        LazyOptional cap = capability.get().entity().getCapability(CuriosCapability.INVENTORY);
        if (!cap.isPresent()) {
            return;
        }
        new WrappedCurioItemHandler(capability);
    }

    @Override
    public Map<String, ICurioStacksHandler> getCurios() {
        HashMap<String, ICurioStacksHandler> handlers = new HashMap<String, ICurioStacksHandler>();
        Optional<AccessoriesCapabilityImpl> capability = this.capability();
        capability.ifPresentOrElse(cap -> cap.getContainers().forEach((s, container) -> handlers.put(CuriosWrappingUtils.accessoriesToCurios(s), new WrappedCurioStackHandler((AccessoriesContainerImpl)container))), () -> LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!"));
        if (capability.isEmpty()) {
            return Map.of();
        }
        handlers.put("curio", new EmptyCuriosStackHandler("curio"));
        return handlers;
    }

    @Override
    public void setCurios(Map<String, ICurioStacksHandler> map) {
    }

    @Override
    public int getSlots() {
        int totalSlots = 0;
        for (ICurioStacksHandler stacks : this.getCurios().values()) {
            totalSlots += stacks.getSlots();
        }
        return totalSlots;
    }

    @Override
    public void reset() {
        this.capability().ifPresent(capability -> capability.reset(false));
    }

    @Override
    public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
        return this.capability().flatMap(capability -> Optional.ofNullable((AccessoriesContainerImpl)capability.getContainers().get(identifier)).map(WrappedCurioStackHandler::new));
    }

    @Override
    public IItemHandlerModifiable getEquippedCurios() {
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
        int index = 0;
        for (ICurioStacksHandler stacksHandler : curios.values()) {
            if (index >= itemHandlers.length) continue;
            itemHandlers[index] = stacksHandler.getStacks();
            ++index;
        }
        return new CombinedInvWrapper(itemHandlers);
    }

    @Override
    public void setEquippedCurio(String identifier, int index, ItemStack stack) {
        this.capability().ifPresent(capability -> {
            AccessoriesContainer container = (AccessoriesContainer)capability.getContainers().get(identifier);
            if (container != null) {
                container.getAccessories().m_6836_(index, stack);
            }
        });
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Item item) {
        return this.findFirstCurio((ItemStack stack) -> stack.m_41720_().equals(item));
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter) {
        return this.capability().flatMap(capability -> Optional.ofNullable(capability.getFirstEquipped(filter))).map(entry -> new SlotResult(CuriosWrappingUtils.create(entry.reference()), entry.stack()));
    }

    @Override
    public List<SlotResult> findCurios(Item item) {
        return this.findCurios((ItemStack stack) -> stack.m_41720_().equals(item));
    }

    @Override
    public List<SlotResult> findCurios(Predicate<ItemStack> filter) {
        return this.capability().stream().flatMap(capability -> capability.getEquipped(filter).stream()).map(entry -> new SlotResult(CuriosWrappingUtils.create(entry.reference()), entry.stack())).toList();
    }

    @Override
    public List<SlotResult> findCurios(String ... identifiers) {
        Set<String> containerIds = Set.of(identifiers);
        Optional<AccessoriesCapabilityImpl> capability = this.capability();
        if (capability.isEmpty()) {
            return List.of();
        }
        return capability.get().getContainers().entrySet().stream().filter(entry -> containerIds.contains(entry.getKey())).map(entry -> {
            AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
            ExpandedSimpleContainer accessories = ((AccessoriesContainer)entry.getValue()).getAccessories();
            ArrayList<SlotEntryReference> references = new ArrayList<SlotEntryReference>();
            for (Pair stackEntry : accessories) {
                ItemStack stack = (ItemStack)stackEntry.getSecond();
                SlotReference reference = container.createReference(((Integer)stackEntry.getFirst()).intValue());
                Accessory accessory = AccessoriesAPI.getOrDefaultAccessory((Item)stack.m_41720_());
                references.add(new SlotEntryReference(reference, stack));
                if (!(accessory instanceof AccessoryNest)) continue;
                AccessoryNest holdable = (AccessoryNest)accessory;
                for (ItemStack innerStack : holdable.getInnerStacks((ItemStack)stackEntry.getSecond())) {
                    references.add(new SlotEntryReference(reference, innerStack));
                }
            }
            return references;
        }).flatMap(references -> references.stream().map(entry -> new SlotResult(CuriosWrappingUtils.create(entry.reference()), entry.stack()))).toList();
    }

    @Override
    public Optional<SlotResult> findCurio(String identifier, int index) {
        Optional<AccessoriesCapabilityImpl> capability = this.capability();
        return capability.flatMap(cap -> Optional.ofNullable((AccessoriesContainer)cap.getContainers().get(identifier))).flatMap(container -> {
            ItemStack stack = container.getAccessories().m_8020_(index);
            if (stack.m_41619_()) {
                return Optional.empty();
            }
            return Optional.of(new SlotResult(new SlotContext(identifier, ((AccessoriesCapabilityImpl)capability.get()).entity(), 0, false, true), stack));
        });
    }

    @Override
    public LivingEntity getWearer() {
        return this.capability().get().entity();
    }

    @Override
    public void loseInvalidStack(ItemStack stack) {
    }

    @Override
    public void handleInvalidStacks() {
    }

    @Override
    public int getFortuneLevel(@Nullable LootContext lootContext) {
        return 0;
    }

    @Override
    public int getLootingLevel(DamageSource source, LivingEntity target, int baseLooting) {
        return 0;
    }

    @Override
    public Set<ICurioStacksHandler> getUpdatingInventories() {
        return null;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().ifPresentOrElse(capability -> capability.addTransientSlotModifiers(modifiers), () -> LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!"));
    }

    @Override
    public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().ifPresentOrElse(capability -> capability.addPersistentSlotModifiers(modifiers), () -> LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!"));
    }

    @Override
    public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().ifPresentOrElse(capability -> capability.removeSlotModifiers(modifiers), () -> LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!"));
    }

    @Override
    public void clearSlotModifiers() {
        this.capability().ifPresentOrElse(capability -> capability.clearSlotModifiers(), () -> LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!"));
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers() {
        return this.capability().map(capability -> capability.getSlotModifiers()).orElseGet(() -> {
            LOGGER.warn("Unable to get the curios handlers from the given entity due to issues with getting the needed capability, expect errors!");
            return HashMultimap.create();
        });
    }

    @Override
    public ListTag saveInventory(boolean clear) {
        CompoundTag outerCompound = new CompoundTag();
        Optional<AccessoriesCapabilityImpl> capability = this.capability();
        if (capability.isPresent()) {
            CompoundTag compound = new CompoundTag();
            ((AccessoriesHolderImpl)capability.get().getHolder()).write((MapCarrier)new NbtMapCarrier(compound), SerializationContext.empty());
            outerCompound.m_128365_("main_data", (Tag)compound);
            outerCompound.m_128379_("is_accessories_data", true);
        }
        ListTag list = new ListTag();
        list.add((Object)outerCompound);
        return list;
    }

    @Override
    public void loadInventory(ListTag data) {
        CompoundTag compound = data.m_128728_(0);
        try {
            Optional<AccessoriesCapabilityImpl> capability = this.capability();
            if (capability.isPresent()) {
                if (compound.m_128441_("is_accessories_data")) {
                    ((AccessoriesHolderImpl)capability.get().getHolder()).read((MapCarrier)new NbtMapCarrier(compound), SerializationContext.empty());
                } else {
                    CurioInventory.readData(this.getWearer(), (AccessoriesCapability)capability.get(), data);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load a wrapped curio inventory as a error occurred, it will not be loaded!", (Throwable)e);
        }
    }

    @Override
    public Tag writeTag() {
        return new CompoundTag();
    }

    @Override
    public void readTag(Tag tag) {
    }

    @Override
    public void clearCachedSlotModifiers() {
        this.capability().ifPresent(AccessoriesCapabilityImpl::clearCachedSlotModifiers);
    }

    @Override
    public void growSlotType(String identifier, int amount) {
    }

    @Override
    public void shrinkSlotType(String identifier, int amount) {
    }
}

