/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.slottype;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.EnumUtils;
import top.theillusivec4.curios.CuriosConstants;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;

public final class SlotType
implements ISlotType {
    private final String identifier;
    private final int order;
    private final int size;
    private final boolean useNativeGui;
    private final boolean hasCosmetic;
    private final ResourceLocation icon;
    private final ICurio.DropRule dropRule;
    private final boolean renderToggle;
    private final Set<ResourceLocation> validators;

    private SlotType(Builder builder) {
        this.identifier = builder.identifier;
        this.order = builder.order;
        this.size = builder.size;
        this.useNativeGui = builder.useNativeGui;
        this.hasCosmetic = builder.hasCosmetic;
        this.icon = builder.icon;
        this.dropRule = builder.dropRule;
        this.renderToggle = builder.renderToggle;
        this.validators = builder.validators;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean useNativeGui() {
        return this.useNativeGui;
    }

    @Override
    public boolean hasCosmetic() {
        return this.hasCosmetic;
    }

    @Override
    public boolean canToggleRendering() {
        return this.renderToggle;
    }

    @Override
    public ICurio.DropRule getDropRule() {
        return this.dropRule;
    }

    @Override
    public Set<ResourceLocation> getValidators() {
        return this.validators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotType that = (SlotType)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @Override
    public int compareTo(ISlotType otherType) {
        if (this.order == otherType.getOrder()) {
            return this.identifier.compareTo(otherType.getIdentifier());
        }
        if (this.order > otherType.getOrder()) {
            return 1;
        }
        return -1;
    }

    public static class Builder {
        public final String identifier;
        public Integer order = null;
        public Integer size = null;
        public int sizeMod = 0;
        public Boolean useNativeGui = null;
        public Boolean hasCosmetic = null;
        public Boolean renderToggle = null;
        public ResourceLocation icon = null;
        public ICurio.DropRule dropRule = null;
        public Set<ResourceLocation> validators = null;

        public Builder(String identifier) {
            this.identifier = identifier;
        }

        public void apply(Builder builder) {
            if (!builder.identifier.equals(this.identifier)) {
                CuriosConstants.LOG.error("Mismatched slot builders {} and {}", (Object)builder.identifier, (Object)this.identifier);
                return;
            }
            if (builder.order != null) {
                this.order(builder.order);
            }
            if (builder.size != null) {
                this.size(builder.size);
            }
            if (builder.useNativeGui != null) {
                this.useNativeGui(builder.useNativeGui);
            }
            if (builder.hasCosmetic != null) {
                this.hasCosmetic(builder.hasCosmetic);
            }
            if (builder.renderToggle != null) {
                this.renderToggle(builder.renderToggle);
            }
            if (builder.icon != null) {
                this.icon(builder.icon);
            }
            if (builder.dropRule != null) {
                this.dropRule(builder.dropRule);
            }
            if (builder.validators != null) {
                this.validators = builder.validators;
            }
        }

        public Builder icon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder order(int order) {
            return this.order(order, false);
        }

        public Builder order(int order, boolean replace) {
            this.order = replace || this.order == null ? order : Math.min(this.order, order);
            return this;
        }

        public Builder size(int size) {
            return this.size(size, false);
        }

        public Builder size(int size, String operation) {
            return this.size(size, operation, false);
        }

        public Builder size(int size, boolean replace) {
            return this.size(size, "SET", replace);
        }

        public Builder size(int size, String operation, boolean replace) {
            switch (operation) {
                case "SET": {
                    this.size = replace || this.size == null ? size : Math.max(this.size, size);
                    if (!replace) break;
                    this.sizeMod = 0;
                    break;
                }
                case "ADD": {
                    this.sizeMod = replace ? size : this.sizeMod + size;
                    break;
                }
                case "REMOVE": {
                    this.sizeMod = replace ? -size : this.sizeMod - size;
                }
            }
            return this;
        }

        public Builder useNativeGui(boolean useNativeGui) {
            return this.useNativeGui(useNativeGui, false);
        }

        public Builder useNativeGui(boolean useNativeGui, boolean replace) {
            this.useNativeGui = replace || this.useNativeGui == null ? useNativeGui : this.useNativeGui != false && useNativeGui;
            return this;
        }

        public Builder renderToggle(boolean renderToggle) {
            return this.renderToggle(renderToggle, false);
        }

        public Builder renderToggle(boolean renderToggle, boolean replace) {
            this.renderToggle = replace || this.renderToggle == null ? renderToggle : this.renderToggle != false && renderToggle;
            return this;
        }

        public Builder hasCosmetic(boolean hasCosmetic) {
            return this.hasCosmetic(hasCosmetic, false);
        }

        public Builder hasCosmetic(boolean hasCosmetic, boolean replace) {
            this.hasCosmetic = replace || this.hasCosmetic == null ? hasCosmetic : this.hasCosmetic != false || hasCosmetic;
            return this;
        }

        public Builder dropRule(ICurio.DropRule dropRule) {
            this.dropRule = dropRule;
            return this;
        }

        public Builder dropRule(String dropRule) {
            ICurio.DropRule newRule = (ICurio.DropRule)EnumUtils.getEnum(ICurio.DropRule.class, (String)dropRule);
            if (newRule == null) {
                CuriosConstants.LOG.error(dropRule + " is not a valid drop rule!");
            } else {
                this.dropRule = newRule;
            }
            return this;
        }

        public Builder validator(ResourceLocation slotResultPredicate) {
            if (this.validators == null) {
                this.validators = new HashSet<ResourceLocation>();
            }
            this.validators.add(slotResultPredicate);
            return this;
        }

        public SlotType build() {
            if (this.order == null) {
                this.order = 1000;
            }
            if (this.size == null) {
                this.size = 1;
            }
            this.size = this.size + this.sizeMod;
            this.size = Math.max(this.size, 0);
            if (this.useNativeGui == null) {
                this.useNativeGui = true;
            }
            if (this.hasCosmetic == null) {
                this.hasCosmetic = false;
            }
            if (this.renderToggle == null) {
                this.renderToggle = true;
            }
            return new SlotType(this);
        }
    }
}

