/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.data.SlotTypeLoader;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.WrappedCurioStackHandler;

public class CurioSlot
extends AccessoriesInternalSlot {
    private final String identifier;
    private final Player player;
    private final SlotContext slotContext;
    private NonNullList<Boolean> renderStatuses;
    private boolean canToggleRender;
    private boolean showCosmeticToggle;
    private boolean isCosmetic;

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender, boolean showCosmeticToggle, boolean isCosmetic) {
        this(player, handler, index, identifier, xPosition, yPosition, renders, canToggleRender);
        this.showCosmeticToggle = showCosmeticToggle;
        this.isCosmetic = isCosmetic;
    }

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender) {
        boolean bl;
        AccessoriesContainer accessoriesContainer = CurioSlot.getContainer(player, identifier);
        if (handler instanceof WrappedCurioStackHandler.HandlerImpl) {
            WrappedCurioStackHandler.HandlerImpl wrapped = (WrappedCurioStackHandler.HandlerImpl)handler;
            bl = wrapped.isCosmetic;
        } else {
            bl = (Boolean)CurioSlot.throwException("Unable to handle passed IDynamicStackHandler as it is not a type that is valid");
        }
        super(0, accessoriesContainer, bl, index, xPosition, yPosition);
        this.isCosmetic = false;
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.canToggleRender = canToggleRender;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index, this instanceof CosmeticCurioSlot, this instanceof CosmeticCurioSlot || (Boolean)renders.get(index) != false);
    }

    public static final <T> T throwException(String message) {
        throw new IllegalStateException(message);
    }

    private static AccessoriesContainer getContainer(Player player, String curiosId) {
        return player.accessoriesCapability().getContainer(SlotTypeLoader.getSlotType((Level)player.m_9236_(), (String)CuriosWrappingUtils.curiosToAccessories(curiosId)));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean canToggleRender() {
        return this.canToggleRender;
    }

    public boolean isCosmetic() {
        return this.isCosmetic;
    }

    public boolean showCosmeticToggle() {
        return this.showCosmeticToggle;
    }

    public boolean getRenderStatus() {
        return this.accessoriesContainer.shouldRender(this.m_150661_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return "";
    }

    public void m_5852_(@Nonnull ItemStack stack) {
        super.m_5852_(stack);
    }

    public boolean m_150651_(@Nonnull Player pPlayer) {
        return super.m_150651_(pPlayer);
    }
}

