/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.cclayer.ImmutableDelegatingMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.crafting.conditions.ICondition;
import top.theillusivec4.curios.CuriosConstants;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.slottype.LegacySlotManager;

public class CuriosEntityManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static CuriosEntityManager SERVER = new CuriosEntityManager(false);
    public static CuriosEntityManager CLIENT = new CuriosEntityManager(true);
    private Map<EntityType<?>, Map<String, ISlotType>> entitySlots = ImmutableMap.of();
    private Map<String, Set<String>> idToMods = ImmutableMap.of();
    private ICondition.IContext ctx = ICondition.IContext.EMPTY;
    private boolean isClient = false;
    public final Map<EntityType<?>, ImmutableSet.Builder<String>> entityTypeSlotData = new HashMap();

    public CuriosEntityManager(boolean isClient) {
        this();
        this.isClient = isClient;
    }

    public CuriosEntityManager() {
        super(GSON, "curios/entities");
    }

    public CuriosEntityManager(ICondition.IContext ctx) {
        super(GSON, "curios/entities");
        this.ctx = ctx;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager pResourceManager, @Nonnull ProfilerFiller pProfiler) {
        this.entityTypeSlotData.clear();
        HashMap<Object, ImmutableSet.Builder> map = new HashMap<Object, ImmutableSet.Builder>();
        HashMap<String, ImmutableSet.Builder> modMap = new HashMap<String, ImmutableSet.Builder>();
        LinkedHashMap sorted = new LinkedHashMap();
        pResourceManager.m_7536_().forEach(packResources -> {
            Set namespaces = packResources.m_5698_(PackType.SERVER_DATA);
            namespaces.forEach(namespace -> packResources.m_8031_(PackType.SERVER_DATA, namespace, "curios/entities", (resourceLocation, inputStreamIoSupplier) -> {
                String path = resourceLocation.m_135815_();
                ResourceLocation rl = new ResourceLocation(namespace, path.substring("curios/entities/".length(), path.length() - ".json".length()));
                JsonElement el = (JsonElement)pObject.get(rl);
                if (el != null) {
                    sorted.put(rl, el);
                }
            }));
        });
        for (String string : LegacySlotManager.getImcBuilders().keySet()) {
            map.computeIfAbsent(EntityType.f_20532_, k -> ImmutableSet.builder()).add((Object)string);
        }
        for (Map.Entry entry2 : sorted.entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry2.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)((JsonElement)entry2.getValue()), (String)"top element");
                for (Map.Entry<EntityType<?>, Set<String>> entry1 : CuriosEntityManager.getSlotsForEntities(jsonObject, resourcelocation, this.ctx).entrySet()) {
                    if (GsonHelper.m_13855_((JsonObject)jsonObject, (String)"replace", (boolean)false)) {
                        ImmutableSet.Builder builder = ImmutableSet.builder();
                        builder.addAll((Iterable)entry1.getValue());
                        map.put(entry1.getKey(), builder);
                    } else {
                        map.computeIfAbsent(entry1.getKey(), k -> ImmutableSet.builder()).addAll((Iterable)entry1.getValue());
                    }
                    modMap.computeIfAbsent(resourcelocation.m_135815_(), k -> ImmutableSet.builder()).add((Object)resourcelocation.m_135827_());
                }
            }
            catch (JsonParseException | IllegalArgumentException e) {
                CuriosConstants.LOG.error("Parsing error loading curio entity {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.idToMods = (Map)modMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
        this.entityTypeSlotData.putAll(map);
        CuriosConstants.LOG.info("Loaded {} curio entities", (Object)map.size());
    }

    public static ListTag getSyncPacket() {
        ListTag tag = new ListTag();
        for (Map.Entry<EntityType<?>, Map<String, ISlotType>> entry : CuriosEntityManager.SERVER.entitySlots.entrySet()) {
            ResourceLocation rl = BuiltInRegistries.f_256780_.m_7981_(entry.getKey());
            CompoundTag entity = new CompoundTag();
            entity.m_128359_("Entity", rl.toString());
            ListTag tag1 = new ListTag();
            for (Map.Entry<String, ISlotType> val : entry.getValue().entrySet()) {
                tag1.add((Object)StringTag.m_129297_((String)val.getKey()));
            }
            entity.m_128365_("Slots", (Tag)tag1);
            tag.add((Object)entity);
        }
        return tag;
    }

    public static void applySyncPacket(ListTag tag) {
        HashMap map = new HashMap();
        for (Tag tag1 : tag) {
            CompoundTag entity;
            EntityType type;
            if (!(tag1 instanceof CompoundTag) || (type = (EntityType)BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation((entity = (CompoundTag)tag1).m_128461_("Entity"))).orElse(null)) == null) continue;
            ListTag slots = entity.m_128437_("Slots", 8);
            for (Tag slot : slots) {
                if (!(slot instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)slot;
                String id = stringTag.m_7916_();
                CuriosSlotManager.CLIENT.getSlot(id).ifPresent(slotType -> map.computeIfAbsent(type, k -> ImmutableMap.builder()).put((Object)id, slotType));
            }
        }
        CuriosEntityManager.CLIENT.entitySlots = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
    }

    private static Map<EntityType<?>, Set<String>> getSlotsForEntities(JsonObject jsonObject, ResourceLocation resourceLocation, ICondition.IContext ctx) {
        HashMap map = new HashMap();
        if (!ICondition.shouldRegisterEntry((JsonElement)jsonObject)) {
            CuriosConstants.LOG.debug("Skipping loading entity file {} as its conditions were not met", (Object)resourceLocation);
            return map;
        }
        JsonArray jsonEntities = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"entities", (JsonArray)new JsonArray());
        HashSet<EntityType> toAdd = new HashSet<EntityType>();
        for (JsonElement jsonEntity : jsonEntities) {
            String entity = jsonEntity.getAsString();
            if (entity.startsWith("#")) {
                BuiltInRegistries.f_256780_.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(entity))).ifPresent(named -> {
                    for (Holder entityTypeHolder : named) {
                        toAdd.add((EntityType)entityTypeHolder.m_203334_());
                    }
                });
                continue;
            }
            EntityType type = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(entity)).orElse(null);
            if (type != null) {
                toAdd.add(type);
                continue;
            }
            CuriosConstants.LOG.error("{} is not a registered entity type!", (Object)entity);
        }
        JsonArray jsonSlots = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"slots", (JsonArray)new JsonArray());
        HashSet<String> slots = new HashSet<String>();
        for (JsonElement jsonSlot : jsonSlots) {
            slots.add(jsonSlot.getAsString());
        }
        for (EntityType entityType : toAdd) {
            map.computeIfAbsent(entityType, k -> new HashSet()).addAll(slots);
        }
        return map;
    }

    public boolean hasSlots(EntityType<?> type) {
        return this.getClientSlots(type).containsKey(type);
    }

    public Map<String, Integer> getClientSlots(EntityType<?> type) {
        Map<String, SlotType> map = EntitySlotLoader.INSTANCE.getSlotTypes(true, type);
        return ImmutableDelegatingMap.slotBaseSize(map != null ? map : Map.of());
    }

    public Map<String, ISlotType> getEntitySlots(EntityType<?> type) {
        Map<String, SlotType> map = EntitySlotLoader.INSTANCE.getSlotTypes(false, type);
        return ImmutableDelegatingMap.slotType(map != null ? map : Map.of());
    }

    public Map<String, Set<String>> getModsFromSlots() {
        return ImmutableMap.copyOf(this.idToMods);
    }
}

