/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.capability.CurioInventory;
import top.theillusivec4.curios.compat.WrappedCurioItemHandler;

public class CurioInventoryCapability {
    public static ICapabilityProvider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;
        final LivingEntity wearer;
        @Nullable
        CompoundTag cachedCompoundTag = null;
        boolean cachedData = false;

        Provider(LivingEntity livingEntity) {
            this.wearer = livingEntity;
            this.handler = new CurioInventoryWrapper(this.wearer);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            if (this.cachedCompoundTag != null && this.cachedData) {
                this.deserializeNBT((Tag)this.cachedCompoundTag);
            }
            if (EntitySlotLoader.getEntitySlots((LivingEntity)this.wearer).isEmpty()) {
                return LazyOptional.empty();
            }
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            if (CuriosApi.getEntitySlots(this.wearer).isEmpty()) {
                return new CompoundTag();
            }
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag nbt) {
            if (!(nbt instanceof CompoundTag)) {
                return;
            }
            CompoundTag compoundTag = (CompoundTag)nbt;
            if (this.cachedCompoundTag == null && !this.cachedData) {
                this.cachedCompoundTag = compoundTag;
                this.cachedData = true;
                return;
            }
            this.cachedCompoundTag = new CompoundTag();
            this.cachedData = false;
            CurioInventory inv = new CurioInventory(new AccessoriesCapabilityImpl(this.wearer));
            inv.deserializeNBT(compoundTag);
            inv.init(this.handler);
        }
    }

    public static class CurioInventoryWrapper
    extends WrappedCurioItemHandler {
        public CurioInventoryWrapper(LivingEntity livingEntity) {
            super(() -> (AccessoriesCapabilityImpl)livingEntity.accessoriesCapability());
        }
    }
}

