/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class CurioInventory
implements INBTSerializable<CompoundTag> {
    private final AccessoriesCapabilityImpl capability;
    CompoundTag deserialized = new CompoundTag();
    boolean markDeserialized = false;

    public CurioInventory(AccessoriesCapabilityImpl capability) {
        this.capability = capability;
    }

    public void init(ICuriosItemHandler curiosItemHandler) {
        LivingEntity livingEntity = this.capability.entity();
        if (this.markDeserialized) {
            this.markDeserialized = false;
            ListTag tagList = this.deserialized.m_128437_("Curios", 10);
            CurioInventory.readData(livingEntity, (AccessoriesCapability)this.capability, tagList);
            this.deserialized = new CompoundTag();
        }
    }

    public static void readData(LivingEntity livingEntity, AccessoriesCapability capability, ListTag data) {
        for (int i = 0; i < data.size(); ++i) {
            CompoundTag tag = data.m_128728_(i);
            String identifier = tag.m_128461_("Identifier");
            SlotType slotType = SlotTypeLoader.getSlotType((Level)livingEntity.m_9236_(), (String)CuriosWrappingUtils.curiosToAccessories(identifier));
            AccessoriesContainer container = slotType != null ? capability.getContainer(slotType) : null;
            ((AccessoriesHolderImpl)capability.getHolder()).invalidStacks.addAll(CurioInventory.deserializeNBT_StackHandler(livingEntity, container, tag.m_128469_("StacksHandler")));
        }
        List invalidStacks = ((AccessoriesHolderImpl)capability.getHolder()).invalidStacks;
        for (SlotEntryReference entryRef : capability.getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (Level)reference.entity().m_9236_(), (SlotType)slotType, (int)0, (ItemStack)entryRef.stack())) continue;
            invalidStacks.add(entryRef.stack().m_41777_());
            entryRef.reference().setStack(ItemStack.f_41583_);
        }
    }

    private static List<ItemStack> deserializeNBT_StackHandler(LivingEntity livingEntity, @Nullable AccessoriesContainer container, CompoundTag nbt) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        if (nbt.m_128441_("Stacks")) {
            dropped.addAll(CurioInventory.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getAccessories, nbt.m_128469_("Stacks")));
        }
        if (nbt.m_128441_("Cosmetics")) {
            dropped.addAll(CurioInventory.deserializeNBT_Stacks(livingEntity, container, AccessoriesContainer::getCosmeticAccessories, nbt.m_128469_("Cosmetics")));
        }
        return dropped;
    }

    private static List<ItemStack> deserializeNBT_Stacks(LivingEntity livingEntity, @Nullable AccessoriesContainer container, Function<AccessoriesContainer, Container> containerFunc, CompoundTag nbt) {
        List<ItemStack> list = nbt.m_128437_("Items", 10).stream().map(tagEntry -> {
            CompoundTag compoundTag;
            return ItemStack.m_41712_((CompoundTag)(tagEntry instanceof CompoundTag ? (compoundTag = (CompoundTag)tagEntry) : new CompoundTag()));
        }).toList();
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        if (container != null) {
            Container accessories = containerFunc.apply(container);
            for (ItemStack stack : list) {
                boolean consumedStack = false;
                for (int i = 0; i < accessories.m_6643_() && !consumedStack; ++i) {
                    ItemStack currentStack = accessories.m_8020_(i);
                    if (!currentStack.m_41619_()) continue;
                    accessories.m_6836_(i, stack.m_41777_());
                    consumedStack = true;
                }
                if (consumedStack) continue;
                dropped.add(stack.m_41777_());
            }
        } else {
            dropped.addAll(list);
        }
        return dropped;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.deserialized = nbt;
        this.markDeserialized = true;
    }
}

