/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class CuriosRendererRegistry {
    private static final Map<Item, Supplier<ICurioRenderer>> RENDERER_REGISTRY = new ConcurrentHashMap<Item, Supplier<ICurioRenderer>>();
    private static final Map<Item, ICurioRenderer> RENDERERS = new HashMap<Item, ICurioRenderer>();

    public static void register(Item item, final Supplier<ICurioRenderer> renderer) {
        AccessoriesRendererRegistry.registerRenderer((Item)item, () -> new AccessoryRenderer(){
            private final ICurioRenderer innerRenderer;
            {
                this.innerRenderer = (ICurioRenderer)renderer.get();
            }

            public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, final EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                SlotContext context = CuriosWrappingUtils.create(reference);
                RenderLayerParent renderLayer = new RenderLayerParent<M, EntityModel<M>>(){

                    public EntityModel<M> m_7200_() {
                        return model;
                    }

                    public ResourceLocation getTextureLocation(M entity) {
                        return new ResourceLocation("");
                    }
                };
                this.innerRenderer.render(stack, context, matrices, renderLayer, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        });
        RENDERER_REGISTRY.put(item, renderer);
    }

    public static Optional<ICurioRenderer> getRenderer(Item item) {
        return Optional.ofNullable(RENDERERS.get(item)).or(() -> Optional.ofNullable(AccessoriesRendererRegistry.getRender((Item)item)).flatMap(accessoryRenderer -> {
            if (accessoryRenderer == DefaultAccessoryRenderer.INSTANCE && !Accessories.getConfig().clientData.forceNullRenderReplacement) {
                return Optional.empty();
            }
            return Optional.of(new ICurioRenderer((AccessoryRenderer)accessoryRenderer){
                final /* synthetic */ AccessoryRenderer val$accessoryRenderer;
                {
                    this.val$accessoryRenderer = accessoryRenderer;
                }

                @Override
                public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                    SlotReference ref = CuriosWrappingUtils.fromContext(slotContext);
                    this.val$accessoryRenderer.render(stack, ref, matrixStack, renderLayerParent.m_7200_(), renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            });
        }));
    }

    public static void load() {
        for (Map.Entry<Item, Supplier<ICurioRenderer>> entry : RENDERER_REGISTRY.entrySet()) {
            RENDERERS.put(entry.getKey(), entry.getValue().get());
        }
    }
}

