/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.cclayer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.cclayer.DeathWrapperEventsImpl;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.WrappedICurioProvider;
import top.theillusivec4.curios.compat.WrappedSlotType;
import top.theillusivec4.curios.mixin.CuriosImplMixinHooks;
import top.theillusivec4.curios.server.SlotHelper;
import top.theillusivec4.curios.server.command.CurioArgumentType;

@Mod(value="cclayer")
public class CCLayer {
    public static final String MODID = "cclayer";
    private boolean attemptRegister = false;
    @Nullable
    private static MinecraftServer server = null;
    public static Supplier<Level> clientLevelSupplier = null;

    public CCLayer() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachEntitiesCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::registerCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldTick);
        CuriosApi.setCuriosHelper(new CuriosHelper());
        CuriosRegistry.init();
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, reference, stateChange) -> MinecraftForge.EVENT_BUS.post((Event)new CurioChangeEvent(reference.entity(), reference.slotName(), reference.slot(), prevStack, currentStack)));
        DeathWrapperEventsImpl.init();
        CanEquipCallback.EVENT.register((stack, reference) -> {
            CurioEquipEvent event = new CurioEquipEvent(stack, CuriosWrappingUtils.create(reference));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return CuriosWrappingUtils.convert(event.getEquipResult());
        });
        CanUnequipCallback.EVENT.register((stack, reference) -> {
            CurioUnequipEvent event = new CurioUnequipEvent(stack, CuriosWrappingUtils.create(reference));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return CuriosWrappingUtils.convert(event.getUnequipResult());
        });
        AdjustAttributeModifierCallback.EVENT.register((stack, reference, builder) -> {
            HashMultimap modifiers = HashMultimap.create();
            Pair data = AttributeUtils.getModifierData((ResourceLocation)new ResourceLocation("curios", AccessoryAttributeBuilder.createSlotPath((SlotReference)reference)));
            CurioAttributeModifierEvent event = new CurioAttributeModifierEvent(stack, CuriosWrappingUtils.create(reference), (UUID)data.right(), (Multimap<Attribute, AttributeModifier>)modifiers);
            MinecraftForge.EVENT_BUS.post((Event)event);
            modifiers.clear();
            modifiers.putAll(event.getModifiers());
        });
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ICuriosItemHandler.class);
        event.register(ICurio.class);
    }

    public void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            event.addCapability(CuriosCapability.ID_INVENTORY, CurioInventoryCapability.createProvider(livingEntity));
        }
    }

    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START) || this.attemptRegister) {
            return;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack defaultStack = item.m_7968_();
            if (!CuriosImplMixinHooks.REGISTRY.containsKey(item) && item instanceof ICurioItem) {
                ICurioItem iCurioItem = (ICurioItem)item;
                CuriosImplMixinHooks.registerCurio(item, iCurioItem);
                continue;
            }
            if (AccessoriesAPI.getAccessory((Item)item) != null || !defaultStack.getCapability(CuriosCapability.ITEM).isPresent()) continue;
            AccessoriesAPI.registerAccessory((Item)item, (Accessory)new WrappedICurioProvider());
        }
        this.attemptRegister = true;
    }

    private void serverAboutToStart(ServerAboutToStartEvent evt) {
        CuriosApi.setSlotHelper(new SlotHelper());
        HashSet<String> slotIds = new HashSet<String>();
        SlotTypeLoader.INSTANCE.getSlotTypes(false).values().stream().map(WrappedSlotType::new).forEach(value -> {
            CuriosApi.getSlotHelper().addSlotType((ISlotType)value);
            slotIds.add(value.getIdentifier());
        });
        CurioArgumentType.slotIds = slotIds;
        server = evt.getServer();
    }

    private void serverStopped(ServerStoppedEvent evt) {
        CuriosApi.setSlotHelper(null);
        server = null;
    }

    @Nullable
    public static MinecraftServer currentServer() {
        return server;
    }

    public static Level getDummyLevel(boolean isClient) {
        Level clientLevel;
        if (isClient && clientLevelSupplier != null && (clientLevel = clientLevelSupplier.get()) != null) {
            return clientLevel;
        }
        MinecraftServer server = CCLayer.currentServer();
        if (server != null) {
            return (Level)server.m_129785_().iterator().next();
        }
        if (!isClient) {
            throw new IllegalStateException("Unable to get the needed Server Level for CCLayer method passed without proper context!");
        }
        throw new IllegalStateException("Unable to get the needed Client Level for CCLayer method passed without proper context!");
    }
}

