/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property.codec;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviorRegistry;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationStageProperties;
import net.minecraft.network.FriendlyByteBuf;

public class AzAnimationStagePropertiesCodec {
    public static final Function<FriendlyByteBuf, AzAnimationStageProperties> DECODER = buf -> {
        int propertyLength = buf.readByte();
        AzAnimationStageProperties properties = AzAnimationStageProperties.EMPTY;
        block7: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    Double animationSpeed = (Double)buf.m_236868_(FriendlyByteBuf::readDouble);
                    properties = properties.withAnimationSpeed(animationSpeed != null ? animationSpeed : 1.0);
                    continue block7;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block7;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.m_130277_(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block7;
                }
                case 3: {
                    AzPlayBehavior playBehavior = AzPlayBehaviorRegistry.getOrDefault(buf.m_130277_(), AzPlayBehaviors.PLAY_ONCE);
                    properties = properties.withPlayBehavior(playBehavior);
                    continue block7;
                }
                case 4: {
                    Double startTickOffset = (Double)buf.m_236868_(FriendlyByteBuf::readDouble);
                    properties = properties.withStartTickOffset(startTickOffset != null ? startTickOffset : 0.0);
                }
            }
        }
        return properties;
    };
    public static final BiConsumer<FriendlyByteBuf, AzAnimationStageProperties> ENCODER = (buf, properties) -> {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        propertyLength += properties.hasPlayBehavior() ? 1 : 0;
        buf.writeByte(propertyLength += properties.hasStartTickOffset() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.writeByte(0);
            buf.writeDouble(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.writeByte(1);
            buf.writeFloat(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.writeByte(2);
            buf.m_130070_(properties.easingType().name());
        }
        if (properties.hasPlayBehavior()) {
            buf.writeByte(3);
            buf.m_130070_(properties.playBehavior().name());
        }
        if (properties.hasStartTickOffset()) {
            buf.writeByte(4);
            buf.writeDouble(properties.startTickOffset());
        }
    };
}

