/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.darkart;

import insane96mcp.insanelib.util.MCUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class DarkArtWitchGoal
extends Goal {
    protected final Witch witch;
    protected LivingEntity target;
    protected Phase phase;
    protected int phaseTick = 0;
    protected Vec3 summonSpot;
    protected Villager villager;

    public DarkArtWitchGoal(Witch witch) {
        this.witch = witch;
        this.phase = Phase.EQUIP_EGG;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        return this.witch.m_5448_() != null && !(this.witch.m_5448_() instanceof Raider) && this.witch.m_5448_().m_20280_((Entity)this.witch) < 100.0 && this.witch.m_21574_().m_148306_((Entity)this.witch.m_5448_()) && this.phase == Phase.EQUIP_EGG;
    }

    public boolean m_8045_() {
        return this.witch.m_5448_() != null && this.phase != Phase.END && (this.summonSpot == null || this.witch.m_20238_(this.summonSpot) <= 256.0);
    }

    public void m_8056_() {
        this.target = this.witch.m_5448_();
        this.witch.getPersistentData().m_128379_("enhancedai:performing_dark_arts", true);
        this.witch.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 2));
        this.witch.m_146915_(true);
        this.witch.m_20334_(0.0, this.witch.m_20184_().f_82480_, 0.0);
    }

    public void m_8041_() {
        this.witch.getPersistentData().m_128379_("enhancedai:performing_dark_arts", false);
        this.witch.m_21195_(MobEffects.f_19606_);
        this.witch.m_21195_(MobEffects.f_19620_);
        this.witch.m_146915_(false);
        this.summonSpot = null;
        if (this.villager != null && !this.villager.m_213877_()) {
            this.villager.m_146870_();
        }
    }

    public void m_8037_() {
        this.witch.m_21573_().m_26573_();
        this.phase.tick(this);
        ++this.phaseTick;
    }

    public boolean isRunning() {
        return this.phaseTick > 0;
    }

    public void forceStop() {
        if (this.villager != null) {
            this.villager.m_6074_();
        }
    }

    private void summonWitch() {
        ServerLevel serverLevel = (ServerLevel)this.witch.m_9236_();
        Witch witch = (Witch)EntityType.f_20495_.m_20615_((Level)serverLevel);
        witch.m_7678_(this.villager.m_20185_(), this.villager.m_20186_(), this.villager.m_20189_(), this.villager.m_146908_(), this.villager.m_146909_());
        witch.m_6518_((ServerLevelAccessor)serverLevel, this.witch.m_9236_().m_6436_(witch.m_20183_()), MobSpawnType.CONVERSION, null, null);
        witch.getPersistentData().m_128379_("enhancedai:dark_arts", false);
        serverLevel.m_47205_((Entity)witch);
        this.villager.m_146870_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Phase {
        EQUIP_EGG{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                if (goal.phaseTick == 20) {
                    goal.witch.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 84, 0));
                }
                if (goal.phaseTick < 26) {
                    goal.witch.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42601_));
                    goal.witch.m_21563_().m_24960_((Entity)goal.target, 180.0f, 180.0f);
                } else {
                    goal.phase = SUMMON_VILLAGER;
                }
            }
        }
        ,
        SUMMON_VILLAGER{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                int x = 0;
                int y = 0;
                int z = 0;
                for (int t = 0; t < 10; ++t) {
                    float angle = goal.witch.m_217043_().m_188501_() * (float)Math.PI * 2.0f;
                    x = (int)(Math.floor(Math.cos(angle) * (double)3.33f) + goal.witch.m_20185_());
                    z = (int)(Math.floor(Math.sin(angle) * (double)3.33f) + goal.witch.m_20189_());
                    y = (int)(goal.witch.m_20186_() + 3.0);
                    if ((y = MCUtils.getFittingY((EntityType)EntityType.f_20492_, (BlockPos)new BlockPos(x, y, z), (Level)goal.witch.m_9236_(), (int)6)) != goal.witch.m_9236_().m_141937_() - 1) break;
                }
                if (y < goal.witch.m_9236_().m_141937_()) {
                    goal.phase = END;
                    return;
                }
                goal.summonSpot = new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
                goal.phase = LOOK_AT_VILLAGER;
                goal.witch.m_21563_().m_24950_(goal.summonSpot.f_82479_, goal.summonSpot.f_82480_, goal.summonSpot.f_82481_, 180.0f, 180.0f);
                goal.villager = new Villager(EntityType.f_20492_, goal.witch.m_9236_());
                goal.villager.m_146884_(goal.summonSpot);
                goal.villager.m_21563_().m_148051_((Entity)goal.witch);
                goal.villager.m_20331_(true);
                goal.villager.m_21557_(true);
                goal.witch.m_9236_().m_7967_((Entity)goal.villager);
                goal.phase = LOOK_AT_VILLAGER;
            }
        }
        ,
        LOOK_AT_VILLAGER{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                if (goal.phaseTick < 46) {
                    goal.witch.m_21563_().m_24960_((Entity)goal.villager, 180.0f, 180.0f);
                } else {
                    goal.phase = IMPRISON_VILLAGER;
                }
            }
        }
        ,
        IMPRISON_VILLAGER{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                if (goal.phaseTick == 47) {
                    goal.villager.m_5496_(SoundEvents.f_11887_, 2.0f, 0.5f);
                    goal.witch.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    goal.phase = LEVITATE;
                }
            }
        }
        ,
        LEVITATE{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                if (goal.phaseTick < 62) {
                    goal.witch.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 2, 1));
                    goal.witch.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123792_, true, goal.witch.m_20185_(), goal.witch.m_20186_(), goal.witch.m_20189_(), 0.1, 0.1, 0.1);
                    goal.witch.m_21563_().m_24960_((Entity)goal.villager, 180.0f, 180.0f);
                } else {
                    goal.phase = LIGHTNING_STRIKE;
                }
            }
        }
        ,
        LIGHTNING_STRIKE{

            @Override
            public void tick(DarkArtWitchGoal goal) {
                if (goal.phaseTick == 63) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, goal.witch.m_9236_());
                    lightningBolt.m_146884_(goal.villager.m_20318_(1.0f));
                    lightningBolt.m_20874_(true);
                    lightningBolt.setDamage(0.0f);
                    goal.witch.m_9236_().m_7967_((Entity)lightningBolt);
                    goal.summonWitch();
                    goal.phase = END;
                }
            }
        }
        ,
        END{

            @Override
            public void tick(DarkArtWitchGoal goal) {
            }
        };

        private static final int EQUIP_EGG_TICK = 26;
        private static final int LOOK_AT_VILLAGER_TICK = 46;
        private static final int IMPRISON_VILLAGER_TICK = 47;
        private static final int LEVITATE_TICK = 62;
        private static final int LIGHTNING_STRIKE_TICK = 63;

        public abstract void tick(DarkArtWitchGoal var1);
    }
}

