/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.pearler;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.pearler.PearlUseGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Let mobs use ender pearls. Either put ender pearls in main or off hand and when far enough from the target they will throw it. Only mobs in the enhancedai:can_be_pearler entity type tag can be pearler.")
public class PearlerMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_PEARLER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("can_be_pearler"));
    public static final String HAS_ENDER_PEARL_BEEN_GIVEN = "enhancedai:has_ender_pearl_been_given";
    @Config(min=0.0, max=1.0, description="Chance for a mob in the entity type tag enhancedai:can_be_pearler to spawn with Ender Pearls in the offhand.\nI recommend Mobs Properties Randomness to have more control over mobs equipment as the mob will always be able to use pearls as long as it has them in the offhand.")
    public static Double equipEnderPearlChance = 0.05;
    @Config(min=0.0, max=16.0, description="How many ender pearls will Mobs spawn with.")
    public static Integer enderPearlAmount = 3;
    @Config(min=1.0, max=16.0, description="Inaccuracy when throwing the ender pearl.")
    public static Integer inaccuracy = 3;

    public PearlerMobs(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_BE_PEARLER) || mob.getPersistentData().m_128471_(HAS_ENDER_PEARL_BEEN_GIVEN)) {
            return;
        }
        if (mob.m_21206_().m_41619_() && mob.m_217043_().m_188500_() < equipEnderPearlChance) {
            mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_, enderPearlAmount.intValue()));
        }
        mob.getPersistentData().m_128379_(HAS_ENDER_PEARL_BEEN_GIVEN, true);
        mob.f_21345_.m_25352_(2, (Goal)new PearlUseGoal(mob));
    }
}

