/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.illager;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAAvoidTargetGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:illager", description="Pillagers try to stay away from the target. Use the enhancedai:pillager_flee entity type tag to add/remove skeletons that are affected by this feature")
public class PillagerFleeTarget
extends Feature {
    public static final TagKey<EntityType<?>> PILLAGER_FLEE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("pillager_flee"));
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to spawn with the ability to avoid the player")
    public static Double avoidPlayerChance = 0.5;
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to be able to shoot while running from a player")
    public static Double attackWhenAvoidingChance = 0.5;
    @Config(min=0.0, max=32.0, description="Distance from a player that counts as near and will make the skeleton run away faster.")
    public static Double fleeDistanceNear = 7.0;
    @Config(min=0.0, max=32.0, description="Distance from a player that will make the skeleton run away.")
    public static Double fleeDistanceFar = 12.0;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the pillager avoids the player and it's within 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedNear = 1.1;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the pillager avoids the player and it's farther than 'Flee Distance Far' blocks from him.")
    public static Double fleeSpeedFar = 1.0;

    public PillagerFleeTarget(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Pillager pillager;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Pillager && (pillager = (Pillager)entity).m_6095_().m_204039_(PILLAGER_FLEE))) {
            return;
        }
        CompoundTag persistentData = pillager.getPersistentData();
        boolean avoidTarget = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:avoid_target", pillager.m_217043_().m_188500_() < avoidPlayerChance);
        boolean attackWhenAvoiding = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:attack_when_avoiding", pillager.m_217043_().m_188500_() < attackWhenAvoidingChance);
        double fleeDistanceFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_far", fleeDistanceFar);
        double fleeDistanceNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_near", fleeDistanceNear);
        double fleeSpeedFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_far", fleeSpeedFar);
        double fleeSpeedNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_near", fleeSpeedNear);
        if (!avoidTarget) {
            return;
        }
        EAAvoidTargetGoal avoidTargetGoal = new EAAvoidTargetGoal((PathfinderMob)pillager, (float)fleeDistanceFar1, (float)fleeDistanceNear1, fleeSpeedNear1, fleeSpeedFar1);
        avoidTargetGoal.setAttackWhenRunning(attackWhenAvoiding);
        pillager.f_21345_.m_25352_(1, (Goal)avoidTargetGoal);
    }
}

