/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModPackResources
implements PackResources {
    protected final String modLogoPath;
    private ResourceLocation id;
    private BuiltInMetadata metadata;
    private PackType packType;

    protected AbstractModPackResources() {
        this("mod_logo.png");
    }

    protected AbstractModPackResources(String modLogoPath) {
        Objects.requireNonNull(modLogoPath, "mod logo path is null");
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        String path = String.join((CharSequence)"/", elements);
        if ("pack.png".equals(path)) {
            return ModLoaderEnvironment.INSTANCE.getModContainer(this.getNamespace()).flatMap(container -> container.findResource(this.modLogoPath)).map(modResource -> () -> Files.newInputStream(modResource, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
    }

    public Set<String> m_5698_(PackType type) {
        Objects.requireNonNull(this.packType, "pack type is null");
        return this.packType == type ? Collections.singleton(this.getNamespace()) : Collections.emptySet();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        Objects.requireNonNull(this.metadata, "metadata is null");
        return (T)this.metadata.m_245920_(deserializer);
    }

    public String m_5542_() {
        return this.id.toString();
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    protected final String getNamespace() {
        Objects.requireNonNull(this.id, "id is null");
        return this.id.m_135827_();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    void setup() {
    }

    @ApiStatus.Internal
    static Pack buildPack(PackType packType, ResourceLocation id, Supplier<AbstractModPackResources> factory, Component title, Component description, boolean required, boolean fixedPosition, boolean hidden, FeatureFlagSet features) {
        PackMetadataSection metadataSection = new PackMetadataSection(description, SharedConstants.m_183709_().m_264084_(packType));
        BuiltInMetadata metadata = BuiltInMetadata.m_246652_((MetadataSectionSerializer)PackMetadataSection.f_243696_, (Object)metadataSection);
        Pack.Info info = CommonAbstractions.INSTANCE.createPackInfo(id, description, metadataSection.m_10374_(), features, hidden);
        return Pack.m_245512_((String)id.toString(), (Component)title, (boolean)required, $ -> {
            AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
            packResources.id = id;
            packResources.metadata = metadata;
            packResources.packType = packType;
            packResources.setup();
            return packResources;
        }, (Pack.Info)info, (PackType)packType, (Pack.Position)Pack.Position.TOP, (boolean)fixedPosition, (PackSource)PackSource.f_10528_);
    }
}

