/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sonsofsins.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.mcreator.sonsofsins.init.SonsOfSinsModItems;
import net.mcreator.sonsofsins.procedures.ShapeShiftingToolItemInHandTickProcedure;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class ShapeShiftingToolItem
extends TieredItem {
    private static final Set<ToolAction> SHAPE_SHIFTING_ACTIONS = (Set)Util.m_137469_(Collections.newSetFromMap(new IdentityHashMap()), actions -> {
        actions.addAll(ToolActions.DEFAULT_SHOVEL_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_PICKAXE_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_AXE_ACTIONS);
    });

    public ShapeShiftingToolItem() {
        super(new Tier(){

            public int m_6609_() {
                return 1600;
            }

            public float m_6624_() {
                return 9.0f;
            }

            public float m_6631_() {
                return 2.0f;
            }

            public int m_6604_() {
                return 9;
            }

            public int m_6601_() {
                return 2;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SonsOfSinsModItems.CRYSTALLIZED_ETHER.get())});
            }
        }, new Item.Properties());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (super.canApplyAtEnchantingTable(new ItemStack((ItemLike)SonsOfSinsModItems.OSSEOUS_PICKAXE.get()), enchantment)) {
            return true;
        }
        if (super.canApplyAtEnchantingTable(new ItemStack((ItemLike)SonsOfSinsModItems.OSSEOUS_AXE.get()), enchantment)) {
            return true;
        }
        if (super.canApplyAtEnchantingTable(new ItemStack((ItemLike)SonsOfSinsModItems.OSSEOUS_SHOVEL.get()), enchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean isCorrectToolForDrops(ItemStack itemstack, BlockState blockstate) {
        double haveUrn = 0.0;
        haveUrn = itemstack.m_41784_().m_128459_("haveUrn");
        int tier = 9;
        if (haveUrn != 1.0) {
            tier = 0;
        }
        if (tier < 3 && blockstate.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (tier < 2 && blockstate.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return tier < 1 && blockstate.m_204336_(BlockTags.f_144286_) ? false : blockstate.m_204336_(BlockTags.f_144280_) || blockstate.m_204336_(BlockTags.f_144281_) || blockstate.m_204336_(BlockTags.f_144282_) || blockstate.m_204336_(BlockTags.f_144283_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return SHAPE_SHIFTING_ACTIONS.contains(action);
    }

    public float m_8102_(ItemStack itemstack, BlockState blockstate) {
        double haveUrn = 0.0;
        haveUrn = itemstack.m_41784_().m_128459_("haveUrn");
        if (haveUrn == 1.0) {
            return 9.0f;
        }
        return 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.8, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_6813_(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.m_41622_(1, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.m_41622_(2, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a75\u00a7oAdapts to destroy every block"));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = world.m_8055_(blockpos);
        BlockState resultToSet = this.useAsAxe(blockstate, context);
        if (context.m_43722_().m_41784_().m_128459_("haveUrn") == 0.0) {
            return InteractionResult.FAIL;
        }
        if (resultToSet == null) {
            if (context.m_43719_() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = null;
            foundResult = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.m_46859_(blockpos.m_7494_())) {
                world.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                context.m_43722_().m_41784_().m_128379_("isPickaxe", false);
                context.m_43722_().m_41784_().m_128379_("isShovel", true);
                context.m_43722_().m_41784_().m_128379_("isAxe", false);
                resultToSet = foundResult;
            } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() && context.m_43722_().m_41784_().m_128471_("isShovel")) {
                if (!world.f_46443_) {
                    world.m_5898_(null, 1009, blockpos, 0);
                }
                context.m_43722_().m_41784_().m_128379_("isPickaxe", false);
                context.m_43722_().m_41784_().m_128379_("isShovel", true);
                context.m_43722_().m_41784_().m_128379_("isAxe", false);
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (resultToSet == null) {
                return InteractionResult.PASS;
            }
        }
        if (!world.f_46443_) {
            ItemStack stack = context.m_43722_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockpos, stack);
            }
            world.m_7731_(blockpos, resultToSet, 11);
            world.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)resultToSet));
            if (player != null && !player.m_150110_().f_35937_) {
                stack.m_220157_(1, RandomSource.m_216327_(), null);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Nullable
    private BlockState useAsAxe(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState resultToSet = state.getToolModifiedState(context, ToolActions.AXE_STRIP, false);
        if (context.m_43722_().m_41784_().m_128459_("haveUrn") == 0.0) {
            return state;
        }
        if (resultToSet != null) {
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            context.m_43722_().m_41784_().m_128379_("isPickaxe", false);
            context.m_43722_().m_41784_().m_128379_("isShovel", false);
            context.m_43722_().m_41784_().m_128379_("isAxe", true);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false);
        if (resultToSet != null) {
            world.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3005, pos, 0);
            context.m_43722_().m_41784_().m_128379_("isPickaxe", false);
            context.m_43722_().m_41784_().m_128379_("isShovel", false);
            context.m_43722_().m_41784_().m_128379_("isAxe", true);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
        if (resultToSet != null) {
            world.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3004, pos, 0);
            context.m_43722_().m_41784_().m_128379_("isPickaxe", false);
            context.m_43722_().m_41784_().m_128379_("isShovel", false);
            context.m_43722_().m_41784_().m_128379_("isAxe", true);
            return resultToSet;
        }
        return null;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        ShapeShiftingToolItemInHandTickProcedure.execute((LevelAccessor)world, entity, itemstack);
    }
}

