/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.components.ConfigWorldSelectionList;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.fml.config.ModConfig;

public class SelectConfigWorldScreen
extends Screen {
    private final Screen lastScreen;
    private final Component displayName;
    private final ModConfig config;
    private final List<LevelSummary> levelList;
    private List<FormattedCharSequence> activeTooltip;
    private EditBox searchBox;
    private ConfigWorldSelectionList list;
    private Button openButton;
    private Button createButton;
    private Button copyButton;
    private Button fileButton;

    public SelectConfigWorldScreen(Screen lastScreen, Component displayName, ModConfig config, List<LevelSummary> levelList) {
        super((Component)Component.m_237110_((String)"configmenusforge.gui.select.world.title", (Object[])new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.config = config;
        if (levelList.isEmpty()) {
            throw new IllegalArgumentException("level list may not be empty, solve this beforehand");
        }
        this.levelList = levelList;
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 121, 22, 242, 20, this.searchBox, (Component)Component.m_237119_()){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchBox.m_94151_(query -> this.list.refreshList((String)query));
        this.searchBox.m_94199_(50);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20).m_253136_());
        this.openButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.edit"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.m_93511_();
            if (selected != null) {
                selected.openConfig();
            }
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 52, 150, 20).m_253136_());
        this.createButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.world.create"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.m_93511_();
            if (selected != null) {
                selected.openConfig();
            }
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 52, 150, 20).m_253136_());
        this.copyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.copy"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.m_93511_();
            if (selected != null) {
                selected.loadModConfig(this.config);
                Path destination = CommonAbstractions.INSTANCE.getDefaultConfigPath().resolve(this.config.getFileName());
                MutableComponent component2 = Files.exists(destination, new LinkOption[0]) ? Component.m_237115_((String)"configmenusforge.gui.message.copy.warning").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"configmenusforge.gui.message.copy.description");
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)this.config.getConfigData(), destination, WritingMode.REPLACE);
                            ForgeConfigScreens.LOGGER.info("Successfully copied {} to default config folder", (Object)this.config.getFileName());
                        }
                        catch (Exception e) {
                            ForgeConfigScreens.LOGGER.error("Failed to copy {} to default config folder", (Object)this.config.getFileName(), (Object)e);
                        }
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, (Component)Component.m_237115_((String)"configmenusforge.gui.message.copy.title"), (Component)component2));
            }
        }).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 52, 150, 20).m_253136_());
        this.fileButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"configmenusforge.gui.select.open"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.m_93511_();
            if (selected != null) {
                selected.loadModConfig(this.config);
                Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.config.getFullPath().toAbsolutePath().toString()));
                this.m_5561_(style);
            }
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20).m_253136_());
        this.updateButtonStatus(false);
        this.list = new ConfigWorldSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 60, 36, this.searchBox.m_94155_(), this.levelList);
        this.m_7787_((GuiEventListener)this.list);
        this.m_264313_((GuiEventListener)this.searchBox);
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k) || this.searchBox.m_7933_(i, j, k);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        return this.searchBox.m_5534_(pCodePoint, pModifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.activeTooltip = null;
        this.list.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.searchBox.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        if (this.activeTooltip != null) {
            guiGraphics.m_280245_(this.f_96547_, this.activeTooltip, pMouseX, pMouseY);
        }
    }

    public void setActiveTooltip(List<FormattedCharSequence> list) {
        this.activeTooltip = list;
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            boolean fileExists;
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.m_93511_();
            this.openButton.f_93624_ = fileExists = selected.fileExists();
            this.createButton.f_93624_ = !fileExists;
            this.openButton.f_93623_ = true;
            this.fileButton.f_93623_ = fileExists;
            this.copyButton.f_93623_ = fileExists;
        } else {
            this.openButton.f_93624_ = true;
            this.openButton.f_93623_ = false;
            this.createButton.f_93624_ = false;
            this.fileButton.f_93623_ = false;
            this.copyButton.f_93623_ = false;
        }
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void m_7861_() {
        if (this.list != null) {
            this.list.m_6702_().forEach(ConfigWorldSelectionList.ConfigWorldListEntry::close);
        }
    }
}

