/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.api.common;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import mod.chloeprime.aaaparticles.common.network.S2CAddParticle;
import mod.chloeprime.aaaparticles.common.util.Basis;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class ParticleEmitterInfo
implements Cloneable {
    public final ResourceLocation effek;
    public final ResourceLocation emitter;
    protected int flags;
    protected double x;
    protected double y;
    protected double z;
    protected float rotX;
    protected float rotY;
    protected float rotZ;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected float scaleZ = 1.0f;
    protected double esX;
    protected double esY;
    protected double esZ;
    protected int boundEntity;
    protected final List<DynamicParameter> parameters = new ArrayList<DynamicParameter>();
    protected final IntList triggers = new IntArrayList();
    private static final Vec3 VEC3_ONES = new Vec3(1.0, 1.0, 1.0);

    public static ParticleEmitterInfo create(Level level, ResourceLocation location) {
        return level.m_5776_() ? new ParticleEmitterInfo(location) : new S2CAddParticle(location);
    }

    public static ParticleEmitterInfo create(Level level, ResourceLocation location, ResourceLocation emitterName) {
        return level.m_5776_() ? new ParticleEmitterInfo(location, emitterName) : new S2CAddParticle(location, emitterName);
    }

    @ApiStatus.Internal
    public ParticleEmitterInfo(ResourceLocation effek) {
        this(effek, null);
    }

    @ApiStatus.Internal
    public ParticleEmitterInfo(ResourceLocation effek, ResourceLocation emitter) {
        this.effek = effek;
        this.emitter = emitter;
        if (emitter != null) {
            this.flags |= 1;
        }
    }

    public ParticleEmitterInfo clone() {
        try {
            return (ParticleEmitterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean hasEmitter() {
        return (this.flags & 1) != 0;
    }

    public final boolean isPositionSet() {
        return (this.flags & 2) != 0;
    }

    public final boolean isRotationSet() {
        return (this.flags & 4) != 0;
    }

    public final boolean isScaleSet() {
        return (this.flags & 8) != 0;
    }

    public final boolean hasParameters() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean hasTriggers() {
        return (this.flags & 0x100) != 0;
    }

    public final boolean hasBoundEntity() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean isEntitySpaceRelativePosSet() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean usingEntityHeadSpace() {
        return (this.flags & 0x40) != 0;
    }

    public ParticleEmitterInfo position(Vec3 pos) {
        return this.position(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public ParticleEmitterInfo position(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.flags |= 2;
        return this;
    }

    public ParticleEmitterInfo rotation(Vec2 rot) {
        return this.rotation(rot.f_82470_, rot.f_82471_, 0.0f);
    }

    public ParticleEmitterInfo rotation(float x, float y, float z) {
        this.rotX = x;
        this.rotY = y;
        this.rotZ = z;
        this.flags |= 4;
        return this;
    }

    public ParticleEmitterInfo scale(float scale) {
        return this.scale(scale, scale, scale);
    }

    public ParticleEmitterInfo scale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
        this.flags |= 8;
        return this;
    }

    public ParticleEmitterInfo parameter(int index, float value) {
        this.parameters.add(new DynamicParameter(index, value));
        this.flags |= 0x80;
        return this;
    }

    public ParticleEmitterInfo trigger(int index) {
        this.triggers.add(index);
        this.flags |= 0x100;
        return this;
    }

    public ParticleEmitterInfo bindOnEntity(Entity entity) {
        this.boundEntity = entity.m_19879_();
        this.flags |= 0x10;
        return this;
    }

    public ParticleEmitterInfo entitySpaceRelativePosition(Vec3 pos) {
        return this.entitySpaceRelativePosition(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public ParticleEmitterInfo entitySpaceRelativePosition(double x, double y, double z) {
        this.esX = x;
        this.esY = y;
        this.esZ = z;
        this.flags |= 0x20;
        return this;
    }

    public ParticleEmitterInfo useEntityHeadSpace() {
        return this.useEntityHeadSpace(true);
    }

    public ParticleEmitterInfo useEntityHeadSpace(boolean value) {
        this.flags = value ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        return this;
    }

    public final Vec3 position() {
        return this.isPositionSet() ? new Vec3(this.x, this.y, this.z) : Vec3.f_82478_;
    }

    public final Vec3 rotation() {
        return this.isRotationSet() ? new Vec3((double)this.rotX, (double)this.rotY, (double)this.rotZ) : Vec3.f_82478_;
    }

    public final Vec3 scale() {
        return this.isScaleSet() ? new Vec3((double)this.scaleX, (double)this.scaleY, (double)this.scaleZ) : VEC3_ONES;
    }

    public Optional<Entity> getBoundEntity(Level level) {
        return this.hasBoundEntity() ? Optional.ofNullable(level.m_6815_(this.boundEntity)) : Optional.empty();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.effek);
        buf.m_130130_(this.flags);
        if (this.hasEmitter()) {
            buf.m_130085_(this.emitter);
        }
        if (this.isPositionSet()) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }
        if (this.isRotationSet()) {
            buf.writeFloat(this.rotX);
            buf.writeFloat(this.rotY);
            buf.writeFloat(this.rotZ);
        }
        if (this.isScaleSet()) {
            buf.writeFloat(this.scaleX);
            buf.writeFloat(this.scaleY);
            buf.writeFloat(this.scaleZ);
        }
        if (this.hasParameters()) {
            buf.m_130130_(this.parameters.size());
            this.parameters.forEach(param -> {
                buf.m_130130_(param.index());
                buf.writeFloat(param.value());
            });
        }
        if (this.hasTriggers()) {
            buf.m_130089_(this.triggers.toIntArray());
        }
        if (this.hasBoundEntity()) {
            buf.m_130130_(this.boundEntity);
        }
        if (this.isEntitySpaceRelativePosSet()) {
            buf.writeDouble(this.esX);
            buf.writeDouble(this.esY);
            buf.writeDouble(this.esZ);
        }
    }

    public ParticleEmitterInfo(FriendlyByteBuf buf) {
        this.effek = buf.m_130281_();
        this.flags = buf.m_130242_();
        this.emitter = this.hasEmitter() ? buf.m_130281_() : null;
        if (this.isPositionSet()) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }
        if (this.isRotationSet()) {
            this.rotX = buf.readFloat();
            this.rotY = buf.readFloat();
            this.rotZ = buf.readFloat();
        }
        if (this.isScaleSet()) {
            this.scaleX = buf.readFloat();
            this.scaleY = buf.readFloat();
            this.scaleZ = buf.readFloat();
        }
        if (this.hasParameters()) {
            int paramCount = buf.m_130242_();
            for (int i = 0; i < paramCount; ++i) {
                int index = buf.m_130242_();
                float value = buf.readFloat();
                this.parameters.add(new DynamicParameter(index, value));
            }
        }
        if (this.hasTriggers()) {
            this.triggers.addElements(0, buf.m_130100_());
        }
        if (this.hasBoundEntity()) {
            this.boundEntity = buf.m_130242_();
        }
        if (this.isEntitySpaceRelativePosSet()) {
            this.esX = buf.readDouble();
            this.esY = buf.readDouble();
            this.esZ = buf.readDouble();
        }
    }

    @ApiStatus.Internal
    public void spawnInWorld(Level level, Player player) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        Optional.ofNullable(EffectRegistry.get(this.effek)).ifPresent(effek -> {
            float z;
            float y;
            float x;
            ParticleEmitter emitter = this.hasEmitter() ? effek.play(this.emitter) : effek.play();
            boolean hasBoundEntity = this.hasBoundEntity();
            boolean isPositionSet = this.isPositionSet();
            boolean isRotationSet = this.isRotationSet();
            boolean isScaleSet = this.isScaleSet();
            boolean hasParams = this.hasParameters();
            boolean hasTriggs = this.hasTriggers();
            if (isPositionSet) {
                x = (float)this.x;
                y = (float)this.y;
                z = (float)this.z;
            } else if (!hasBoundEntity && player != null) {
                x = (float)player.m_20185_();
                y = (float)player.m_20186_();
                z = (float)player.m_20189_();
            } else {
                z = 0.0f;
                y = 0.0f;
                x = 0.0f;
            }
            if (!hasBoundEntity) {
                emitter.setPosition(x, y, z);
            }
            if (isRotationSet) {
                emitter.setRotation(this.rotX, this.rotY, this.rotZ);
            }
            if (isScaleSet) {
                emitter.setScale(this.scaleX, this.scaleY, this.scaleZ);
            }
            if (hasParams) {
                for (DynamicParameter parameter : this.parameters) {
                    emitter.setDynamicInput(parameter.index(), parameter.value());
                }
            }
            if (hasTriggs) {
                this.triggers.forEach(emitter::sendTrigger);
            }
            if (hasBoundEntity) {
                WeakReference<Entity> entity = new WeakReference<Entity>(level.m_6815_(this.boundEntity));
                boolean headSpace = this.usingEntityHeadSpace();
                boolean entitySpace = headSpace || this.isEntitySpaceRelativePosSet();
                float rotZ = this.rotZ;
                ParticleEmitter.PreDrawCallback updater = (em, partial) -> Optional.ofNullable((Entity)entity.get()).filter(Entity::m_6084_).ifPresentOrElse(et -> {
                    float relZ;
                    float relY;
                    float relX;
                    if (entitySpace) {
                        Basis basis;
                        float rotX;
                        float rotY;
                        if (headSpace) {
                            rotY = (float)Math.toRadians(et.m_5675_(partial));
                            rotX = (float)Math.toRadians(et.m_5686_(partial));
                            basis = Basis.fromEuler(new Vec3((double)(-rotX), (double)((float)Math.PI - rotY), (double)rotZ));
                        } else {
                            rotY = (float)Math.toRadians(Mth.m_14179_((float)partial, (float)et.f_19859_, (float)et.m_146908_()));
                            rotX = 0.0f;
                            basis = Basis.fromEntityBody(et);
                        }
                        Vec3 esRelPos = basis.toGlobal(new Vec3(this.esX, this.esY, this.esZ));
                        relX = (float)((double)x + esRelPos.f_82479_);
                        relY = (float)((double)y + esRelPos.f_82480_);
                        relZ = (float)((double)z + esRelPos.f_82481_);
                        em.setRotation(this.rotX + rotX, this.rotY - rotY, rotZ);
                    } else {
                        relX = x;
                        relY = y;
                        relZ = z;
                    }
                    em.setPosition((float)Mth.m_14139_((double)partial, (double)et.f_19790_, (double)et.m_20185_()) + relX, (float)Mth.m_14139_((double)partial, (double)et.f_19791_, (double)et.m_20186_()) + relY + (headSpace ? et.m_20192_() : 0.0f), (float)Mth.m_14139_((double)partial, (double)et.f_19792_, (double)et.m_20189_()) + relZ);
                }, em::stop);
                updater.accept(emitter, 0.0f);
                emitter.addPreDrawCallback(updater);
            }
        });
    }

    @ApiStatus.Internal
    public void copyTo(ParticleEmitterInfo target) {
        target.flags = this.flags;
        target.x = this.x;
        target.y = this.y;
        target.z = this.z;
        target.rotX = this.rotX;
        target.rotY = this.rotY;
        target.rotZ = this.rotZ;
        target.scaleX = this.scaleX;
        target.scaleY = this.scaleY;
        target.scaleZ = this.scaleZ;
        target.parameters.clear();
        target.parameters.addAll(this.parameters);
        target.triggers.clear();
        target.triggers.addAll(this.triggers);
        target.boundEntity = this.boundEntity;
    }
}

