/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.selector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public record InjectionPointMatcher(@Nullable String value, TargetMatcher target) {
    public static final Codec<InjectionPointMatcher> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("value").forGetter(i -> Optional.ofNullable(i.value())), (App)Codec.STRING.fieldOf("target").forGetter(m -> m.target().target())).apply((Applicative)instance, InjectionPointMatcher::new));

    public InjectionPointMatcher(Optional<String> value, String target) {
        this((String)value.orElse(null), target);
    }

    public InjectionPointMatcher(@Nullable String value, String target) {
        this(value, TargetMatcher.create(target));
    }

    public boolean test(String value, String target) {
        return (this.value == null || this.value.equals(value)) && this.target.test(target);
    }

    static interface TargetMatcher
    extends Predicate<String> {
        public String target();

        public static TargetMatcher create(String target) {
            return Optional.of(target).flatMap(str -> MethodQualifier.create(str).filter(q -> q.name() != null).map(q -> new MethodQualifierMatcher((String)str, (MethodQualifier)q))).orElseGet(() -> new SimpleTargetMatcher(AdapterUtil.maybeRemapFieldRef(target)));
        }
    }

    private record MethodQualifierMatcher(String target, MethodQualifier qualifier) implements TargetMatcher
    {
        @Override
        public boolean test(String s) {
            return MethodQualifier.create(s).map(this.qualifier::matches).orElse(false);
        }
    }

    private record SimpleTargetMatcher(String target) implements TargetMatcher
    {
        @Override
        public boolean test(String s) {
            return this.target.equals(s);
        }
    }
}

