/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.localizedchat.commands;

import com.kreezcraft.localizedchat.CommonClass;
import com.kreezcraft.localizedchat.ConfigCache;
import com.kreezcraft.localizedchat.mixin.PlayerListAccessor;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TalkChat {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"shout").then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(source -> {
            ConfigCache.updateCache();
            if (ConfigCache.shoutDisabled) {
                MutableComponent component = Component.m_237115_((String)"localizedchat.shout.disabled");
                HoverEvent configHover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"localizedchat.shout.config"));
                component.m_6270_(component.m_7383_().m_131144_(configHover));
                ((CommandSourceStack)source.getSource()).m_81352_((Component)component);
                return 0;
            }
            CommandSourceStack sourceStack = (CommandSourceStack)source.getSource();
            PlayerList playerlist = sourceStack.m_81377_().m_6846_();
            Entity entity = sourceStack.m_81373_();
            ServerPlayer commandUser = sourceStack.m_230896_();
            if (commandUser == null) {
                return 0;
            }
            if (entity instanceof Player) {
                Player commandSender = (Player)entity;
                if (ConfigCache.shoutFoodCost > 0) {
                    float foodLevel = commandSender.m_36324_().m_38702_();
                    if (foodLevel >= (float)ConfigCache.shoutFoodCost) {
                        commandSender.m_36324_().m_38705_(Math.max(0, commandSender.m_36324_().m_38702_() - ConfigCache.shoutFoodCost));
                    } else {
                        ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237115_((String)"localizedchat.shout.not_enough_food"));
                        return 0;
                    }
                }
            }
            int range = TalkChat.isPlayerOpped(sourceStack.m_81377_(), commandUser) && !ConfigCache.opAsPlayer ? 300000 : ConfigCache.shoutTalkRange;
            MessageArgument.m_245478_((CommandContext)source, (String)"message", message -> {
                Objects.requireNonNull(commandUser);
                Predicate<ServerPlayer> distancePredicate = player -> player.m_143421_(player) && CommonClass.compareCoordinatesDistance(commandUser.m_20183_(), player.m_20183_()) <= (double)range;
                ((PlayerListAccessor)playerlist).localizedchat$broadcastChatMessage((PlayerChatMessage)message, distancePredicate, commandUser, ChatType.m_241073_((ResourceKey)ChatType.f_130598_, (CommandSourceStack)sourceStack));
            });
            return 0;
        })));
    }

    public static boolean isPlayerOpped(MinecraftServer server, ServerPlayer player) {
        return server.m_6846_().m_11307_().m_11388_((Object)player.m_36316_()) != null;
    }
}

