/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block;

import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.block.v1.TickingEntityBlock;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.shapes.v1.ShapesHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    public static final BooleanProperty HAS_MAP = BooleanProperty.m_61465_((String)"has_map");
    public static final BooleanProperty DYED = BooleanProperty.m_61465_((String)"dyed");
    static final VoxelShape SHAPE = ItemFrameBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    static final VoxelShape MAP_SHAPE = ItemFrameBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    static final Map<Direction, VoxelShape> SHAPES = ShapesHelper.rotate((VoxelShape)SHAPE);
    static final Map<Direction, VoxelShape> MAP_SHAPES = ShapesHelper.rotate((VoxelShape)MAP_SHAPE);
    public static final Map<Item, Block> BY_ITEM = new HashMap<Item, Block>();
    private final Item item;

    public ItemFrameBlock(Item item, BlockBehaviour.Properties properties) {
        super(properties);
        this.item = item;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)INVISIBLE, (Comparable)Boolean.FALSE)).m_61124_((Property)HAS_MAP, (Comparable)Boolean.FALSE)).m_61124_((Property)DYED, (Comparable)Boolean.FALSE));
        Item.f_41373_.put(this, item);
        BY_ITEM.put(item, (Block)this);
    }

    public Item m_5456_() {
        return this.item;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            InteractionResult result;
            if (player.m_36341_() && !this.isFixed((LevelReader)level, pos) && !itemFrame.m_31822_().m_41619_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)INVISIBLE) == false)), 2);
                itemFrame.m_5496_(itemFrame.m_142545_(), 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (itemFrame.m_31822_().m_41619_()) {
                itemFrame.m_31770_(0);
            }
            if ((result = itemFrame.m_6096_(player, hand)).m_19077_()) {
                blockEntity.markUpdated();
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_MAP) != false ? MAP_SHAPES.get(state.m_61143_((Property)FACING)) : SHAPES.get(state.m_61143_((Property)FACING));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)context).m_193113_()) instanceof Projectile) {
            Level level;
            Projectile projectile = (Projectile)entity;
            if (blockGetter instanceof Level && projectile.m_142265_(level = (Level)blockGetter, pos) && projectile.m_6095_().m_204039_(EntityTypeTags.f_13124_)) {
                return this.m_5940_(state, blockGetter, pos, context);
            }
        }
        return super.m_5939_(state, blockGetter, pos, context);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isFixed(level, pos)) {
            return true;
        }
        BlockState blockState = level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        return blockState.m_280296_() || DiodeBlock.m_52586_((BlockState)blockState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntityType<? extends ItemFrameBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.m_203334_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ItemFrameBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, INVISIBLE, HAS_MAP, WATERLOGGED, DYED});
    }

    public boolean isFixed(LevelReader level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemFrame itemFrame = blockEntity2.getEntityRepresentation();
            return itemFrame != null && itemFrame.f_31755_;
        }
        return false;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.m_82425_();
        if (!level.f_46443_ && !this.isFixed((LevelReader)level, blockPos) && projectile.m_142265_(level, blockPos) && projectile.m_6095_().m_204039_(EntityTypeTags.f_13124_)) {
            level.m_46953_(blockPos, true, (Entity)projectile);
            level.m_46672_(blockPos, (Block)this);
            level.m_46672_(blockPos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Block)this);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            ItemFrameBlockEntity blockEntity;
            ItemFrame itemFrame;
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
                itemFrame.m_31802_(null, false);
                blockEntity.m_6596_();
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            return itemFrame.m_31824_();
        }
        return 0;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            ItemFrame itemFrame;
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemStack itemStack = null;
            if ((!Proxy.INSTANCE.hasControlDown() || ModLoaderEnvironment.INSTANCE.isClient() && !Proxy.INSTANCE.getClientPlayer().m_7500_()) && (itemFrame = blockEntity2.getEntityRepresentation()) != null) {
                itemStack = itemFrame.m_142340_();
            }
            if (itemStack == null) {
                itemStack = super.m_7397_(level, pos, state);
            }
            if (itemStack.m_41720_() instanceof ItemFrameItem) {
                ItemFrameBlock.setItemFrameColor(itemStack, blockEntity2.getColor());
            }
            return itemStack;
        }
        return super.m_7397_(level, pos, state);
    }

    public String m_7705_() {
        return this.m_5456_().m_5524_();
    }

    public static ItemStack setItemFrameColor(ItemStack itemStack, OptionalInt color) {
        if (color.isPresent()) {
            ((DyeableLeatherItem)itemStack.m_41720_()).m_41115_(itemStack, color.getAsInt());
        }
        return itemStack;
    }
}

