/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemFrameBlockRenderer
implements BlockEntityRenderer<ItemFrameBlockEntity> {
    public static final Map<ModelResourceLocation, ResourceLocation> ITEM_FRAME_BLOCK_MODELS = ImmutableMap.builder().put((Object)ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=false"), (Object)FastItemFrames.id("block/item_frame")).put((Object)ModelResourceLocation.m_245263_((String)"glow_item_frame", (String)"map=false"), (Object)FastItemFrames.id("block/glow_item_frame")).put((Object)ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=true"), (Object)FastItemFrames.id("block/item_frame_map")).put((Object)ModelResourceLocation.m_245263_((String)"glow_item_frame", (String)"map=true"), (Object)FastItemFrames.id("block/glow_item_frame_map")).build();
    private final EntityRenderDispatcher entityRenderer;

    public ItemFrameBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.m_234446_();
    }

    public void render(ItemFrameBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemFrame itemFrame;
        if (!blockEntity.getItem().m_41619_() && (itemFrame = blockEntity.getEntityRepresentation()) != null) {
            EntityRenderer entityRenderer = this.entityRenderer.m_114382_((Entity)itemFrame);
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.25f, 0.5f);
            Direction direction = itemFrame.m_6350_();
            poseStack.m_252880_((float)direction.m_122429_() * -0.1675f, (float)direction.m_122430_() * -0.46875f, (float)direction.m_122431_() * -0.1675f);
            if (!blockEntity.isInvisible()) {
                poseStack.m_252880_((float)direction.m_122429_() * 0.0625f, (float)direction.m_122430_() * 0.0625f, (float)direction.m_122431_() * 0.0625f);
            }
            if (this.shouldShowName(blockEntity, itemFrame)) {
                entityRenderer.m_7649_((Entity)itemFrame, itemFrame.m_5446_(), poseStack, buffer, packedLight);
            }
            boolean invisible = itemFrame.m_20145_();
            itemFrame.m_6842_(true);
            entityRenderer.m_7392_((Entity)itemFrame, 0.0f, partialTick, poseStack, buffer, packedLight);
            itemFrame.m_6842_(invisible);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRender(ItemFrameBlockEntity blockEntity, Vec3 cameraPos) {
        ItemFrame itemFrame = blockEntity.getEntityRepresentation();
        if (itemFrame != null) {
            return itemFrame.m_6000_(cameraPos.m_7096_(), cameraPos.m_7098_(), cameraPos.m_7094_());
        }
        return super.m_142756_((BlockEntity)blockEntity, cameraPos);
    }

    protected boolean shouldShowName(ItemFrameBlockEntity blockEntity, ItemFrame entity) {
        if (Minecraft.m_91404_() && !entity.m_31822_().m_41619_() && entity.m_31822_().m_41788_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            HitResult hitResult = minecraft.f_91077_;
            if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && blockEntity.m_58899_().equals((Object)((BlockHitResult)hitResult).m_82425_())) {
                double distanceToEntity = minecraft.f_91063_.m_109153_().m_90583_().m_82557_(entity.m_20182_());
                double permittedDistance = entity.m_20163_() ? 32.0 : 64.0;
                return distanceToEntity < permittedDistance * permittedDistance;
            }
        }
        return false;
    }
}

