/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepdarkregrowth.network;

import java.util.function.Supplier;
import net.mcreator.deepdarkregrowth.DeepDarkRegrowthMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DeepDarkRegrowthModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DeepDarkRegrowthMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        DeepDarkRegrowthMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.KonamiCode__UP1 = message.data.KonamiCode__UP1;
                    variables.KonamiCode__UP2 = message.data.KonamiCode__UP2;
                    variables.KonamiCode__DOWN1 = message.data.KonamiCode__DOWN1;
                    variables.KonamiCode__DOWN2 = message.data.KonamiCode__DOWN2;
                    variables.KonamiCode__LEFT1 = message.data.KonamiCode__LEFT1;
                    variables.KonamiCode__RIGHT1 = message.data.KonamiCode__RIGHT1;
                    variables.KonamiCode__LEFT2 = message.data.KonamiCode__LEFT2;
                    variables.KonamiCode__RIGHT2 = message.data.KonamiCode__RIGHT2;
                    variables.KonamiCode__B = message.data.KonamiCode__B;
                    variables.KonamiCode__A = message.data.KonamiCode__A;
                    variables.KonamiCode__ENTER = message.data.KonamiCode__ENTER;
                    variables.KonamiCode__START = message.data.KonamiCode__START;
                    variables.PlayerMaxHealth22 = message.data.PlayerMaxHealth22;
                    variables.PlayerMaxHealth24 = message.data.PlayerMaxHealth24;
                    variables.PlayerMaxHealth26 = message.data.PlayerMaxHealth26;
                    variables.PlayerMaxHealth28 = message.data.PlayerMaxHealth28;
                    variables.PlayerMaxHealth30 = message.data.PlayerMaxHealth30;
                    variables.CaveChimesPlaying = message.data.CaveChimesPlaying;
                    variables.NewMaxHealth1 = message.data.NewMaxHealth1;
                    variables.NewMaxHealth2 = message.data.NewMaxHealth2;
                    variables.NewMaxHealth3 = message.data.NewMaxHealth3;
                    variables.NewMaxHealth4 = message.data.NewMaxHealth4;
                    variables.NewMaxHealth5 = message.data.NewMaxHealth5;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean KonamiCode__UP1 = false;
        public boolean KonamiCode__UP2 = false;
        public boolean KonamiCode__DOWN1 = false;
        public boolean KonamiCode__DOWN2 = false;
        public boolean KonamiCode__LEFT1 = false;
        public boolean KonamiCode__RIGHT1 = false;
        public boolean KonamiCode__LEFT2 = false;
        public boolean KonamiCode__RIGHT2 = false;
        public boolean KonamiCode__B = false;
        public boolean KonamiCode__A = false;
        public boolean KonamiCode__ENTER = false;
        public boolean KonamiCode__START = true;
        public boolean PlayerMaxHealth22 = false;
        public boolean PlayerMaxHealth24 = false;
        public boolean PlayerMaxHealth26 = false;
        public boolean PlayerMaxHealth28 = false;
        public boolean PlayerMaxHealth30 = false;
        public boolean CaveChimesPlaying = false;
        public boolean NewMaxHealth1 = false;
        public boolean NewMaxHealth2 = false;
        public boolean NewMaxHealth3 = false;
        public boolean NewMaxHealth4 = false;
        public boolean NewMaxHealth5 = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("KonamiCode__UP1", this.KonamiCode__UP1);
            nbt.m_128379_("KonamiCode__UP2", this.KonamiCode__UP2);
            nbt.m_128379_("KonamiCode__DOWN1", this.KonamiCode__DOWN1);
            nbt.m_128379_("KonamiCode__DOWN2", this.KonamiCode__DOWN2);
            nbt.m_128379_("KonamiCode__LEFT1", this.KonamiCode__LEFT1);
            nbt.m_128379_("KonamiCode__RIGHT1", this.KonamiCode__RIGHT1);
            nbt.m_128379_("KonamiCode__LEFT2", this.KonamiCode__LEFT2);
            nbt.m_128379_("KonamiCode__RIGHT2", this.KonamiCode__RIGHT2);
            nbt.m_128379_("KonamiCode__B", this.KonamiCode__B);
            nbt.m_128379_("KonamiCode__A", this.KonamiCode__A);
            nbt.m_128379_("KonamiCode__ENTER", this.KonamiCode__ENTER);
            nbt.m_128379_("KonamiCode__START", this.KonamiCode__START);
            nbt.m_128379_("PlayerMaxHealth22", this.PlayerMaxHealth22);
            nbt.m_128379_("PlayerMaxHealth24", this.PlayerMaxHealth24);
            nbt.m_128379_("PlayerMaxHealth26", this.PlayerMaxHealth26);
            nbt.m_128379_("PlayerMaxHealth28", this.PlayerMaxHealth28);
            nbt.m_128379_("PlayerMaxHealth30", this.PlayerMaxHealth30);
            nbt.m_128379_("CaveChimesPlaying", this.CaveChimesPlaying);
            nbt.m_128379_("NewMaxHealth1", this.NewMaxHealth1);
            nbt.m_128379_("NewMaxHealth2", this.NewMaxHealth2);
            nbt.m_128379_("NewMaxHealth3", this.NewMaxHealth3);
            nbt.m_128379_("NewMaxHealth4", this.NewMaxHealth4);
            nbt.m_128379_("NewMaxHealth5", this.NewMaxHealth5);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.KonamiCode__UP1 = nbt.m_128471_("KonamiCode__UP1");
            this.KonamiCode__UP2 = nbt.m_128471_("KonamiCode__UP2");
            this.KonamiCode__DOWN1 = nbt.m_128471_("KonamiCode__DOWN1");
            this.KonamiCode__DOWN2 = nbt.m_128471_("KonamiCode__DOWN2");
            this.KonamiCode__LEFT1 = nbt.m_128471_("KonamiCode__LEFT1");
            this.KonamiCode__RIGHT1 = nbt.m_128471_("KonamiCode__RIGHT1");
            this.KonamiCode__LEFT2 = nbt.m_128471_("KonamiCode__LEFT2");
            this.KonamiCode__RIGHT2 = nbt.m_128471_("KonamiCode__RIGHT2");
            this.KonamiCode__B = nbt.m_128471_("KonamiCode__B");
            this.KonamiCode__A = nbt.m_128471_("KonamiCode__A");
            this.KonamiCode__ENTER = nbt.m_128471_("KonamiCode__ENTER");
            this.KonamiCode__START = nbt.m_128471_("KonamiCode__START");
            this.PlayerMaxHealth22 = nbt.m_128471_("PlayerMaxHealth22");
            this.PlayerMaxHealth24 = nbt.m_128471_("PlayerMaxHealth24");
            this.PlayerMaxHealth26 = nbt.m_128471_("PlayerMaxHealth26");
            this.PlayerMaxHealth28 = nbt.m_128471_("PlayerMaxHealth28");
            this.PlayerMaxHealth30 = nbt.m_128471_("PlayerMaxHealth30");
            this.CaveChimesPlaying = nbt.m_128471_("CaveChimesPlaying");
            this.NewMaxHealth1 = nbt.m_128471_("NewMaxHealth1");
            this.NewMaxHealth2 = nbt.m_128471_("NewMaxHealth2");
            this.NewMaxHealth3 = nbt.m_128471_("NewMaxHealth3");
            this.NewMaxHealth4 = nbt.m_128471_("NewMaxHealth4");
            this.NewMaxHealth5 = nbt.m_128471_("NewMaxHealth5");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("deep_dark_regrowth", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "deep_dark_regrowth_mapvars";
        public boolean StalkerDefeated = false;
        public boolean LifeFruitsWork = true;
        public boolean StalkerAmbientEnabled = true;
        public boolean WardenHelmetEnabled = true;
        public boolean AllowInfectionSpread = true;
        public boolean SpreadWithoutPlayer = false;
        public boolean stalkerallowed = true;
        public boolean tentaclelampallowed = true;
        public boolean soulkeyallowed = true;
        public boolean sculkparasiteallowed = true;
        public boolean spreaderallowed = true;
        public boolean corruptedskeletonallowed = true;
        public boolean stalkerstatueallowed = true;
        public boolean infectionspiderallowed = true;
        public boolean abominationallowed = true;
        public boolean observerallowed = true;
        public boolean spectatorallowed = true;
        public boolean annihilatorallowed = true;
        public boolean hunterallowed = true;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.StalkerDefeated = nbt.m_128471_("StalkerDefeated");
            this.LifeFruitsWork = nbt.m_128471_("LifeFruitsWork");
            this.StalkerAmbientEnabled = nbt.m_128471_("StalkerAmbientEnabled");
            this.WardenHelmetEnabled = nbt.m_128471_("WardenHelmetEnabled");
            this.AllowInfectionSpread = nbt.m_128471_("AllowInfectionSpread");
            this.SpreadWithoutPlayer = nbt.m_128471_("SpreadWithoutPlayer");
            this.stalkerallowed = nbt.m_128471_("stalkerallowed");
            this.tentaclelampallowed = nbt.m_128471_("tentaclelampallowed");
            this.soulkeyallowed = nbt.m_128471_("soulkeyallowed");
            this.sculkparasiteallowed = nbt.m_128471_("sculkparasiteallowed");
            this.spreaderallowed = nbt.m_128471_("spreaderallowed");
            this.corruptedskeletonallowed = nbt.m_128471_("corruptedskeletonallowed");
            this.stalkerstatueallowed = nbt.m_128471_("stalkerstatueallowed");
            this.infectionspiderallowed = nbt.m_128471_("infectionspiderallowed");
            this.abominationallowed = nbt.m_128471_("abominationallowed");
            this.observerallowed = nbt.m_128471_("observerallowed");
            this.spectatorallowed = nbt.m_128471_("spectatorallowed");
            this.annihilatorallowed = nbt.m_128471_("annihilatorallowed");
            this.hunterallowed = nbt.m_128471_("hunterallowed");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("StalkerDefeated", this.StalkerDefeated);
            nbt.m_128379_("LifeFruitsWork", this.LifeFruitsWork);
            nbt.m_128379_("StalkerAmbientEnabled", this.StalkerAmbientEnabled);
            nbt.m_128379_("WardenHelmetEnabled", this.WardenHelmetEnabled);
            nbt.m_128379_("AllowInfectionSpread", this.AllowInfectionSpread);
            nbt.m_128379_("SpreadWithoutPlayer", this.SpreadWithoutPlayer);
            nbt.m_128379_("stalkerallowed", this.stalkerallowed);
            nbt.m_128379_("tentaclelampallowed", this.tentaclelampallowed);
            nbt.m_128379_("soulkeyallowed", this.soulkeyallowed);
            nbt.m_128379_("sculkparasiteallowed", this.sculkparasiteallowed);
            nbt.m_128379_("spreaderallowed", this.spreaderallowed);
            nbt.m_128379_("corruptedskeletonallowed", this.corruptedskeletonallowed);
            nbt.m_128379_("stalkerstatueallowed", this.stalkerstatueallowed);
            nbt.m_128379_("infectionspiderallowed", this.infectionspiderallowed);
            nbt.m_128379_("abominationallowed", this.abominationallowed);
            nbt.m_128379_("observerallowed", this.observerallowed);
            nbt.m_128379_("spectatorallowed", this.spectatorallowed);
            nbt.m_128379_("annihilatorallowed", this.annihilatorallowed);
            nbt.m_128379_("hunterallowed", this.hunterallowed);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "deep_dark_regrowth_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.PlayerMaxHealth22 = original.PlayerMaxHealth22;
            clone.PlayerMaxHealth24 = original.PlayerMaxHealth24;
            clone.PlayerMaxHealth26 = original.PlayerMaxHealth26;
            clone.PlayerMaxHealth28 = original.PlayerMaxHealth28;
            clone.PlayerMaxHealth30 = original.PlayerMaxHealth30;
            clone.NewMaxHealth1 = original.NewMaxHealth1;
            clone.NewMaxHealth2 = original.NewMaxHealth2;
            clone.NewMaxHealth3 = original.NewMaxHealth3;
            clone.NewMaxHealth4 = original.NewMaxHealth4;
            clone.NewMaxHealth5 = original.NewMaxHealth5;
            if (!event.isWasDeath()) {
                clone.KonamiCode__UP1 = original.KonamiCode__UP1;
                clone.KonamiCode__UP2 = original.KonamiCode__UP2;
                clone.KonamiCode__DOWN1 = original.KonamiCode__DOWN1;
                clone.KonamiCode__DOWN2 = original.KonamiCode__DOWN2;
                clone.KonamiCode__LEFT1 = original.KonamiCode__LEFT1;
                clone.KonamiCode__RIGHT1 = original.KonamiCode__RIGHT1;
                clone.KonamiCode__LEFT2 = original.KonamiCode__LEFT2;
                clone.KonamiCode__RIGHT2 = original.KonamiCode__RIGHT2;
                clone.KonamiCode__B = original.KonamiCode__B;
                clone.KonamiCode__A = original.KonamiCode__A;
                clone.KonamiCode__ENTER = original.KonamiCode__ENTER;
                clone.KonamiCode__START = original.KonamiCode__START;
                clone.CaveChimesPlaying = original.CaveChimesPlaying;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                DeepDarkRegrowthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

