/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.platform.forge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.satisfy.sleepy_hollows.forge.config.SleepyHollowsForgeConfig;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;

public class PlatformHelperImpl
extends PlatformHelper {
    public static int getTerrablenderRegionWeight() {
        return (Integer)SleepyHollowsForgeConfig.TERRABLENDER_REGION_WEIGHT.get();
    }

    public static double getHorsemanMovementSpeed() {
        return (Double)SleepyHollowsForgeConfig.HORSEMAN_MOVEMENT_SPEED.get();
    }

    public static double getHorsemanMaxHealth() {
        return (Double)SleepyHollowsForgeConfig.HORSEMAN_MAX_HEALTH.get();
    }

    public static double getHorsemanAttackDamage() {
        return (Double)SleepyHollowsForgeConfig.HORSEMAN_ATTACK_DAMAGE.get();
    }

    public static double getHorsemanAttackKnockback() {
        return (Double)SleepyHollowsForgeConfig.HORSEMAN_ATTACK_KNOCKBACK.get();
    }

    public static double getHorsemanArmor() {
        return (Double)SleepyHollowsForgeConfig.HORSEMAN_ARMOR.get();
    }

    public static double getFleeingPumpkinMaxHealth() {
        return (Double)SleepyHollowsForgeConfig.FLEEING_PUMPKINHEAD_MAX_HEALTH.get();
    }

    public static double getFleeingPumpkinMovementSpeed() {
        return (Double)SleepyHollowsForgeConfig.FLEEING_PUMPKINHEAD_MOVEMENT_SPEED.get();
    }

    public static double getFleeingPumpkinArmor() {
        return (Double)SleepyHollowsForgeConfig.FLEEING_PUMPKINHEAD_ARMOR.get();
    }

    public static double getInfectedZombieMaxHealth() {
        return (Double)SleepyHollowsForgeConfig.INFECTED_ZOMBIE_MAX_HEALTH.get();
    }

    public static double getInfectedZombieArmor() {
        return (Double)SleepyHollowsForgeConfig.INFECTED_ZOMBIE_ARMOR.get();
    }

    public static double getInfectedZombieMovementSpeed() {
        return (Double)SleepyHollowsForgeConfig.INFECTED_ZOMBIE_MOVEMENT_SPEED.get();
    }

    public static double getInfectedZombieAttackDamage() {
        return (Double)SleepyHollowsForgeConfig.INFECTED_ZOMBIE_ATTACK_DAMAGE.get();
    }

    public static double getSpectralToolSpeed() {
        return (Double)SleepyHollowsForgeConfig.SPECTRAL_TOOL_SPEED.get();
    }

    public static double getSpectralToolDamage() {
        return (Double)SleepyHollowsForgeConfig.SPECTRAL_TOOL_DAMAGE.get();
    }

    public static double getRaubbauToolSpeed() {
        return (Double)SleepyHollowsForgeConfig.RAUBBAU_TOOL_SPEED.get();
    }

    public static double getRaubbauToolDamage() {
        return (Double)SleepyHollowsForgeConfig.RAUBBAU_TOOL_DAMAGE.get();
    }

    public static boolean isHauntboundSetBonusEnabled() {
        return (Boolean)SleepyHollowsForgeConfig.ENABLE_HAUNTBOUND_SET_BONUS.get();
    }

    public static int getHauntboundDurability(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_HELMET_DURABILITY.get();
            case ArmorItem.Type.CHESTPLATE -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_CHESTPLATE_DURABILITY.get();
            case ArmorItem.Type.LEGGINGS -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_LEGGINGS_DURABILITY.get();
            case ArmorItem.Type.BOOTS -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_BOOTS_DURABILITY.get();
        };
    }

    public static int getHauntboundDefense(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_HELMET_DEFENSE.get();
            case ArmorItem.Type.CHESTPLATE -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_CHESTPLATE_DEFENSE.get();
            case ArmorItem.Type.LEGGINGS -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_LEGGINGS_DEFENSE.get();
            case ArmorItem.Type.BOOTS -> (Integer)SleepyHollowsForgeConfig.HAUNTBOUND_BOOTS_DEFENSE.get();
        };
    }

    public static double getHauntboundToughness() {
        return (Double)SleepyHollowsForgeConfig.HAUNTBOUND_TOUGHNESS.get();
    }

    public static double getHauntboundKnockbackResistance() {
        return (Double)SleepyHollowsForgeConfig.HAUNTBOUND_KNOCKBACK_RESISTANCE.get();
    }

    public static List<ItemStack> getHorsemanLootItems() {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        for (String lootString : (List)SleepyHollowsForgeConfig.HORSEMAN_LOOT_ITEMS.get()) {
            int count;
            String[] parts = lootString.split(":");
            if (parts.length != 3) continue;
            String modId = parts[0];
            String itemId = parts[1];
            try {
                count = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                count = 1;
            }
            ResourceLocation rl = new ResourceLocation(modId, itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (item != null) {
                loot.add(new ItemStack((ItemLike)item, count));
                continue;
            }
            System.err.println("Horseman Loot Item not found: " + String.valueOf(rl));
        }
        return loot;
    }
}

