/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SoulfireSpiral {
    private final Vec3 center;
    private final double y;
    private final int totalPoints = 800;
    private int currentPoint = 0;
    private final Level level;
    private final List<SoulfireBlock> activeSoulfireBlocks = new ArrayList<SoulfireBlock>();

    public SoulfireSpiral(Level level, Vec3 center) {
        this.level = level;
        this.center = center;
        this.y = center.f_82480_;
    }

    public boolean isFinished() {
        return this.currentPoint >= 800;
    }

    public void tick() {
        int pointsPerTick = 5;
        int i = 0;
        while (i < pointsPerTick && this.currentPoint < 800) {
            double angle = (double)this.currentPoint * 0.05;
            double radius = 0.6 * angle * 0.67;
            double x = this.center.f_82479_ + radius * Math.cos(angle);
            double z = this.center.f_82481_ + radius * Math.sin(angle);
            double y = this.y + 0.3;
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            BlockPos belowPos = pos.m_7495_();
            if (this.level.m_46859_(pos) && this.level.m_8055_(belowPos).m_60815_()) {
                this.level.m_7731_(pos, Blocks.f_50084_.m_49966_(), 3);
                this.activeSoulfireBlocks.add(new SoulfireBlock(pos));
            }
            this.sendParticles(x, y, z);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.ignitePlayersNearby(serverLevel, x, y, z);
            }
            ++i;
            ++this.currentPoint;
        }
        this.cleanupSoulfireBlocks();
    }

    private void sendParticles(double x, double y, double z) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 2, 0.2, 0.2, 0.2, 0.05);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 1, 0.2, 0.2, 0.2, 0.05);
            if (this.currentPoint % 80 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y + 1.0, z, 60, 1.0, 1.0, 1.0, 0.05);
            } else if (this.currentPoint % 53 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y + 1.0, z, 50, 1.0, 1.0, 1.0, 0.05);
            } else if (this.currentPoint % 160 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y + 1.0, z, 75, 1.0, 1.0, 1.0, 0.05);
            }
        }
    }

    private void ignitePlayersNearby(ServerLevel serverLevel, double x, double y, double z) {
        AABB detectionBox = new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
        List players = serverLevel.m_6443_(Player.class, detectionBox, EntitySelector.f_20406_);
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8941_.m_9290_() != GameType.SURVIVAL) continue;
            serverPlayer.m_20254_(8);
        }
    }

    private void cleanupSoulfireBlocks() {
        if (!this.level.m_5776_() && !this.activeSoulfireBlocks.isEmpty()) {
            Iterator<SoulfireBlock> iterator = this.activeSoulfireBlocks.iterator();
            while (iterator.hasNext()) {
                SoulfireBlock sfBlock = iterator.next();
                --sfBlock.ticksRemaining;
                if (sfBlock.ticksRemaining > 0 || this.level.m_8055_(sfBlock.pos).m_60734_() != Blocks.f_50084_) continue;
                this.level.m_7731_(sfBlock.pos, Blocks.f_50016_.m_49966_(), 3);
                iterator.remove();
            }
        }
    }

    private static class SoulfireBlock {
        BlockPos pos;
        int ticksRemaining = 30;

        SoulfireBlock(BlockPos pos) {
            this.pos = pos;
        }
    }
}

