/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SleepyHollowsUtil {
    public static final int NEW_STRUCTURE_SIZE = 512;

    public static <T extends Block> RegistrySupplier<T> abstractBlockRegistration(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> abstractItemRegistration(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static <T extends Block> RegistrySupplier<T> abstractBlockWithoutItemRegistration(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Block> RegistrySupplier<T> abstractBlockItemRegistration(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = SleepyHollowsUtil.abstractBlockRegistration(registerB, registrarB, name, block);
        SleepyHollowsUtil.abstractItemRegistration(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Fluid> RegistrySupplier<T> abstractFluidRegistration(DeferredRegister<Fluid> register, Registrar<Fluid> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static String unwrappedBiome(Holder<Biome> biomeHolder) {
        return (String)biomeHolder.m_203439_().map(arg -> arg.m_135782_().toString(), arg -> "[unregistered " + String.valueOf(arg) + "]");
    }
}

