/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.sleepy_hollows.core.network.SleepyHollowsNetwork;
import net.satisfy.sleepy_hollows.core.network.message.SanityPacketMessage;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.TagRegistry;
import net.satisfy.sleepy_hollows.core.util.IEntitySavedData;

public class SanityManager {
    public static final String SANITY = "sanity";
    public static final int MINIMUM_SANITY = 0;
    public static final int MAXIMUM_SANITY = 100;

    private static int safeSanity(int amount) {
        if (amount < 0) {
            return 0;
        }
        if (amount > 100) {
            return 100;
        }
        return amount;
    }

    public static boolean isImmune(ServerPlayer player) {
        return player.m_21023_((MobEffect)MobEffectRegistry.MENTAL_FORTITUDE.get());
    }

    public static boolean isClientImmune(LocalPlayer player) {
        return player.m_21023_((MobEffect)MobEffectRegistry.MENTAL_FORTITUDE.get());
    }

    public static IEntitySavedData getSavedData(ServerPlayer serverPlayer) {
        return (IEntitySavedData)serverPlayer;
    }

    public static IEntitySavedData getClientSavedData(LocalPlayer clientPlayer) {
        return (IEntitySavedData)clientPlayer;
    }

    public static CompoundTag getSanityTag(IEntitySavedData playerData) {
        return playerData.impl$getPersistentData();
    }

    public static CompoundTag getClientSanityTag(IEntitySavedData playerData) {
        return playerData.impl$getPersistentData();
    }

    public static int getSanity(ServerPlayer player) {
        CompoundTag nbt = SanityManager.getSanityTag(SanityManager.getSavedData(player));
        if (!nbt.m_128425_(SANITY, 3)) {
            nbt.m_128405_(SANITY, 100);
        }
        return nbt.m_128451_(SANITY);
    }

    public static int getClientSanity(LocalPlayer player) {
        CompoundTag nbt = SanityManager.getSanityTag(SanityManager.getClientSavedData(player));
        if (!nbt.m_128425_(SANITY, 3)) {
            nbt.m_128405_(SANITY, 100);
        }
        return nbt.m_128451_(SANITY);
    }

    public static void decreaseSanity(ServerPlayer player, int amount) {
        int currentSanity = SanityManager.getSanity(player);
        if (SanityManager.isImmune(player)) {
            return;
        }
        int newSanity = Math.max(0, currentSanity + amount);
        SanityManager.getSanityTag(SanityManager.getSavedData(player)).m_128405_(SANITY, SanityManager.safeSanity(newSanity));
    }

    public static void decreaseClientSanity(LocalPlayer player, int amount) {
        int currentSanity = SanityManager.getClientSanity(player);
        if (SanityManager.isClientImmune(player)) {
            return;
        }
        int newSanity = Math.max(0, currentSanity + amount);
        SanityManager.getClientSanityTag(SanityManager.getClientSavedData(player)).m_128405_(SANITY, SanityManager.safeSanity(newSanity));
    }

    private static void increaseSanity(ServerPlayer player, int amount) {
        int currentSanity = SanityManager.getSanity(player);
        int newSanity = Math.min(100, currentSanity + amount);
        SanityManager.getSanityTag(SanityManager.getSavedData(player)).m_128405_(SANITY, SanityManager.safeSanity(newSanity));
    }

    private static void increaseClientSanity(LocalPlayer player, int amount) {
        int currentSanity = SanityManager.getClientSanity(player);
        int newSanity = Math.min(100, currentSanity + amount);
        SanityManager.getClientSanityTag(SanityManager.getClientSavedData(player)).m_128405_(SANITY, SanityManager.safeSanity(newSanity));
    }

    public static void changeSanity(ServerPlayer player, int amount) {
        if (SanityManager.isImmune(player)) {
            return;
        }
        if (amount != 0) {
            if (amount > 0) {
                SanityManager.increaseSanity(player, amount);
            } else {
                SanityManager.decreaseSanity(player, amount);
            }
        }
    }

    public static void changeClientSanity(LocalPlayer player, int amount) {
        if (SanityManager.isClientImmune(player)) {
            return;
        }
        if (amount != 0) {
            if (amount > 0) {
                SanityManager.increaseClientSanity(player, amount);
            } else {
                SanityManager.decreaseClientSanity(player, amount);
            }
        }
    }

    public static void doBlockCheck(ServerPlayer serverPlayer) {
        BlockPos blockPos;
        Level level = serverPlayer.m_9236_();
        BlockState blockState = level.m_8055_(blockPos = serverPlayer.m_20183_());
        if (blockState.m_204336_(TagRegistry.RESET_SANITY)) {
            SanityManager.changeSanity(serverPlayer, Modifiers.RESET_SANITY.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(serverPlayer, (Object)new SanityPacketMessage(Modifiers.RESET_SANITY.getValue()));
        }
        if (!SanityManager.isImmune(serverPlayer) && blockState.m_204336_(TagRegistry.DECREASE_SANITY)) {
            SanityManager.changeSanity(serverPlayer, Modifiers.DECREASE_SANITY.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(serverPlayer, (Object)new SanityPacketMessage(Modifiers.DECREASE_SANITY.getValue()));
        }
    }

    public static boolean isSanityBarVisible(LocalPlayer player) {
        return SanityManager.getClientSanity(player) < 100;
    }

    public static enum Modifiers {
        CANDY_CORN(4),
        DUSK_BERRY(2),
        LUMINOUS_WATER(6),
        SPECTRAL_PUMPKIN_PIE(10),
        INSIDE_BIOME(-1),
        OUTSIDE_BIOME(5),
        RESET_SANITY(100),
        DECREASE_SANITY(-2),
        INFECTED_EFFECT(-2),
        MENTAL_FORTITUDE(100);

        final int value;

        private Modifiers(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

