/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleArc {
    private final Vec3 startPos;
    private final Vec3 endPos;
    private final Vec3 midPos;
    private final int numSteps;
    private int currentStep;
    private final int stepsPerTick;

    public ParticleArc(Vec3 startPos, Vec3 endPos, int duration) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.midPos = startPos.m_82549_(endPos).m_82490_(0.5).m_82520_(0.0, 5.0, 0.0);
        this.numSteps = 50;
        this.currentStep = 0;
        this.stepsPerTick = Math.max(1, this.numSteps / duration);
    }

    public boolean isFinished() {
        return this.currentStep >= this.numSteps;
    }

    public void tick(Level level) {
        int i = 0;
        while (i < this.stepsPerTick && this.currentStep < this.numSteps) {
            double t = (double)this.currentStep / (double)this.numSteps;
            Vec3 point = this.quadraticBezier(this.startPos, this.midPos, this.endPos, t);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, 0.0, 0.0);
            ++i;
            ++this.currentStep;
        }
    }

    private Vec3 quadraticBezier(Vec3 p0, Vec3 p1, Vec3 p2, double t) {
        double oneMinusT = 1.0 - t;
        return p0.m_82490_(oneMinusT * oneMinusT).m_82549_(p1.m_82490_(2.0 * oneMinusT * t)).m_82549_(p2.m_82490_(t * t));
    }
}

