/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.registry;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EquipableCarvedPumpkinBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.sleepy_hollows.core.block.custom.BigTombstoneBlock;
import net.satisfy.sleepy_hollows.core.block.custom.CoffinBlock;
import net.satisfy.sleepy_hollows.core.block.custom.CompletionistBannerBlock;
import net.satisfy.sleepy_hollows.core.block.custom.CompletionistWallBannerBlock;
import net.satisfy.sleepy_hollows.core.block.custom.CreakingPlanksBlock;
import net.satisfy.sleepy_hollows.core.block.custom.DuskberryBushBlock;
import net.satisfy.sleepy_hollows.core.block.custom.InfectedFlowerBlock;
import net.satisfy.sleepy_hollows.core.block.custom.InfectedTallFlowerBlock;
import net.satisfy.sleepy_hollows.core.block.custom.PedestalBlock;
import net.satisfy.sleepy_hollows.core.block.custom.SpectralLanternBlock;
import net.satisfy.sleepy_hollows.core.block.custom.SpectralPumpkinBlock;
import net.satisfy.sleepy_hollows.core.block.custom.TombstoneBlock;
import net.satisfy.sleepy_hollows.core.block.custom.WindowBlock;
import net.satisfy.sleepy_hollows.core.item.custom.CandyCornItem;
import net.satisfy.sleepy_hollows.core.item.custom.DuskBerryItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundBootsItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundChestplateItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundHelmetItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundLeggingsItem;
import net.satisfy.sleepy_hollows.core.item.custom.LootBagItem;
import net.satisfy.sleepy_hollows.core.item.custom.LuminousWaterItem;
import net.satisfy.sleepy_hollows.core.item.custom.RaubbauItem;
import net.satisfy.sleepy_hollows.core.item.custom.ReinsOfTheSpectralHorseItem;
import net.satisfy.sleepy_hollows.core.item.custom.ShatterbrandSwordItem;
import net.satisfy.sleepy_hollows.core.item.custom.SpectralPumpkinPieItem;
import net.satisfy.sleepy_hollows.core.item.custom.SpectralWarAxeItem;
import net.satisfy.sleepy_hollows.core.registry.ArmorMaterialRegistry;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsUtil;
import org.jetbrains.annotations.NotNull;

public class ObjectRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"sleepy_hollows", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"sleepy_hollows", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final RegistrySupplier<Block> GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> GRAVESTONE_STAIRS = ObjectRegistry.registerBlockWithBlockItem("gravestone_stairs", () -> new StairBlock(((Block)GRAVESTONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> GRAVESTONE_SLAB = ObjectRegistry.registerBlockWithBlockItem("gravestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> GRAVESTONE_WALL = ObjectRegistry.registerBlockWithBlockItem("gravestone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> COBBLED_GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("cobbled_gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> COBBLED_GRAVESTONE_STAIRS = ObjectRegistry.registerBlockWithBlockItem("cobbled_gravestone_stairs", () -> new StairBlock(((Block)COBBLED_GRAVESTONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> COBBLED_GRAVESTONE_SLAB = ObjectRegistry.registerBlockWithBlockItem("cobbled_gravestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)COBBLED_GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> COBBLED_GRAVESTONE_WALL = ObjectRegistry.registerBlockWithBlockItem("cobbled_gravestone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)COBBLED_GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> CHISELED_GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("chiseled_gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> GRAVESTONE_BRICKS = ObjectRegistry.registerBlockWithBlockItem("gravestone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> GRAVESTONE_BRICK_STAIRS = ObjectRegistry.registerBlockWithBlockItem("gravestone_brick_stairs", () -> new StairBlock(((Block)GRAVESTONE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> GRAVESTONE_BRICK_SLAB = ObjectRegistry.registerBlockWithBlockItem("gravestone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> GRAVESTONE_BRICK_WALL = ObjectRegistry.registerBlockWithBlockItem("gravestone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> CRACKED_GRAVESTONE_BRICKS = ObjectRegistry.registerBlockWithBlockItem("cracked_gravestone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_BRICKS = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_BRICK_STAIRS = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_brick_stairs", () -> new StairBlock(((Block)MOSSY_GRAVESTONE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_BRICK_SLAB = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_BRICK_WALL = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> MOSSY_COBBLED_GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("mossy_cobbled_gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> MOSSY_COBBLED_GRAVESTONE_STAIRS = ObjectRegistry.registerBlockWithBlockItem("mossy_cobbled_gravestone_stairs", () -> new StairBlock(((Block)MOSSY_GRAVESTONE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> MOSSY_COBBLED_GRAVESTONE_SLAB = ObjectRegistry.registerBlockWithBlockItem("mossy_cobbled_gravestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> MOSSY_COBBLED_GRAVESTONE_WALL = ObjectRegistry.registerBlockWithBlockItem("mossy_cobbled_gravestone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE_BRICKS.get()))));
    public static final RegistrySupplier<Block> MOSSY_CHISELED_GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("mossy_chiseled_gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_STAIRS = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_stairs", () -> new StairBlock(((Block)MOSSY_GRAVESTONE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_SLAB = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> MOSSY_GRAVESTONE_WALL = ObjectRegistry.registerBlockWithBlockItem("mossy_gravestone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MOSSY_GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> HOLLOW_LOG = ObjectRegistry.registerBlockWithBlockItem("hollow_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
    public static final RegistrySupplier<Block> HOLLOW_WOOD = ObjectRegistry.registerBlockWithBlockItem("hollow_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
    public static final RegistrySupplier<Block> STRIPPED_HOLLOW_WOOD = ObjectRegistry.registerBlockWithBlockItem("stripped_hollow_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
    public static final RegistrySupplier<Block> STRIPPED_HOLLOW_LOG = ObjectRegistry.registerBlockWithBlockItem("stripped_hollow_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
    public static final RegistrySupplier<Block> HOLLOW_PLANKS = ObjectRegistry.registerBlockWithBlockItem("hollow_planks", () -> new CreakingPlanksBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_284180_(MapColor.f_283927_)));
    public static final RegistrySupplier<Block> HOLLOW_STAIRS = ObjectRegistry.registerBlockWithBlockItem("hollow_stairs", () -> new StairBlock(((Block)HOLLOW_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistrySupplier<Block> HOLLOW_PRESSURE_PLATE = ObjectRegistry.registerBlockWithBlockItem("hollow_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_).m_284180_(((Block)HOLLOW_PLANKS.get()).m_284356_()), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> HOLLOW_DOOR = ObjectRegistry.registerBlockWithBlockItem("hollow_door", () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_284180_(((Block)HOLLOW_PLANKS.get()).m_284356_()), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> HOLLOW_FENCE_GATE = ObjectRegistry.registerBlockWithBlockItem("hollow_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_284180_(((Block)HOLLOW_PLANKS.get()).m_284356_()), WoodType.f_61830_));
    public static final RegistrySupplier<Block> HOLLOW_SLAB = ObjectRegistry.registerBlockWithBlockItem("hollow_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistrySupplier<Block> HOLLOW_BUTTON = ObjectRegistry.registerBlockWithBlockItem("hollow_button", () -> {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
        properties = properties.m_246843_(new FeatureFlag[]{FeatureFlags.f_244571_});
        return new ButtonBlock(properties, BlockSetType.f_271198_, 30, true);
    });
    public static final RegistrySupplier<Block> HOLLOW_TRAPDOOR = ObjectRegistry.registerBlockWithBlockItem("hollow_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> HOLLOW_FENCE = ObjectRegistry.registerBlockWithBlockItem("hollow_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> HOLLOW_WINDOW = ObjectRegistry.registerBlockWithBlockItem("hollow_window", () -> new WindowBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56744_).m_60955_().m_60971_((state, world, pos) -> false).m_60960_((state, world, pos) -> false).m_284180_(MapColor.f_283824_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> HOLLOW_LEAVES = ObjectRegistry.registerBlockWithBlockItem("hollow_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60971_((state, world, pos) -> false).m_60960_((state, world, pos) -> false).m_284180_(MapColor.f_283824_)));
    public static final RegistrySupplier<Block> HOLLOW_SAPLING = ObjectRegistry.registerBlockWithBlockItem("hollow_sapling", () -> new SaplingBlock(new AbstractTreeGrower(){

        @NotNull
        protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(@NotNull RandomSource random, boolean bees) {
            return ObjectRegistry.configuredFeatureKey("hollow_tree_mid");
        }
    }, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistrySupplier<Block> MOONVEIL_GRASS = ObjectRegistry.registerBlockWithBlockItem("moonveil_grass", () -> new InfectedFlowerBlock(Objects.requireNonNull(MobEffect.m_19453_((int)3)), 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)));
    public static final RegistrySupplier<Block> TALL_MOONVEIL_GRASS = ObjectRegistry.registerBlockWithBlockItem("tall_moonveil_grass", () -> new InfectedTallFlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_)));
    public static final RegistrySupplier<Block> DUSKBERRY_BUSH = ObjectRegistry.registerBlockWithoutItem("duskberry_bush", () -> new DuskberryBushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_)));
    public static final RegistrySupplier<Block> GRAVE_LILY = ObjectRegistry.registerBlockWithBlockItem("grave_lily", () -> new InfectedFlowerBlock(Objects.requireNonNull(MobEffect.m_19453_((int)5)), 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50116_)));
    public static final RegistrySupplier<Block> DREAMSHADE = ObjectRegistry.registerBlockWithBlockItem("dreamshade", () -> new InfectedFlowerBlock(Objects.requireNonNull(MobEffect.m_19453_((int)1)), 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50116_)));
    public static final RegistrySupplier<Block> SHADOWBLOOM = ObjectRegistry.registerBlockWithBlockItem("shadowbloom", () -> new InfectedFlowerBlock(Objects.requireNonNull(MobEffect.m_19453_((int)7)), 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50116_)));
    public static final RegistrySupplier<Block> TALL_DREAMSHADE = ObjectRegistry.registerBlockWithBlockItem("tall_dreamshade", () -> new InfectedTallFlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50357_)));
    public static final RegistrySupplier<Block> PEDESTAL = ObjectRegistry.registerBlockWithBlockItem("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60978_(36000.0f).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> WOODEN_TOMBSTONE = ObjectRegistry.registerBlockWithBlockItem("wooden_tombstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get())).m_60953_(state -> (Boolean)state.m_61143_((Property)TombstoneBlock.ACTIVE) != false ? 10 : 0), TombstoneBlock.createWoodenTombstoneShape()));
    public static final RegistrySupplier<Block> SMALL_TOMBSTONE = ObjectRegistry.registerBlockWithBlockItem("small_tombstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get())).m_60953_(state -> (Boolean)state.m_61143_((Property)TombstoneBlock.ACTIVE) != false ? 10 : 0), TombstoneBlock.createSmallTombstoneShape()));
    public static final RegistrySupplier<Block> MID_TOMBSTONE = ObjectRegistry.registerBlockWithBlockItem("mid_tombstone", () -> new TombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get())).m_60953_(state -> (Boolean)state.m_61143_((Property)TombstoneBlock.ACTIVE) != false ? 10 : 0), TombstoneBlock.createMidTombstoneShape()));
    public static final RegistrySupplier<Block> BIG_TOMBSTONE = ObjectRegistry.registerBlockWithBlockItem("big_tombstone", () -> new BigTombstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GRAVESTONE.get()))));
    public static final RegistrySupplier<Block> WROUGHT_IRON_FENCE = ObjectRegistry.registerBlockWithBlockItem("wrought_iron_fence", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_)));
    public static final RegistrySupplier<Block> SPECTRAL_LANTERN = ObjectRegistry.registerBlockWithBlockItem("spectral_lantern", () -> new SpectralLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_)));
    public static final RegistrySupplier<Block> SPECTRAL_PUMPKIN = ObjectRegistry.registerBlockWithBlockItem("spectral_pumpkin", () -> new SpectralPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50133_)));
    public static final RegistrySupplier<Block> SPECTRAL_CARVED_PUMPKIN = ObjectRegistry.registerBlockWithBlockItem("spectral_carved_pumpkin", () -> new EquipableCarvedPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_)));
    public static final RegistrySupplier<Block> SPECTRAL_JACK_O_LANTERN = ObjectRegistry.registerBlockWithBlockItem("spectral_jack_o_lantern", () -> new EquipableCarvedPumpkinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60953_(blockStatex -> 15).m_60922_((state, world, pos, entityType) -> true).m_278166_(PushReaction.DESTROY)));
    public static final RegistrySupplier<Item> HAUNTBOUND_HELMET = ObjectRegistry.registerItem("hauntbound_helmet", () -> new HauntboundHelmetItem(ArmorMaterialRegistry.HAUNTBOUND_ARMOR, ArmorItem.Type.HELMET, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC), new SleepyHollowsIdentifier("textures/models/armor/hauntbound_helmet.png")));
    public static final RegistrySupplier<Item> HAUNTBOUND_CHESTPLATE = ObjectRegistry.registerItem("hauntbound_chestplate", () -> new HauntboundChestplateItem(ArmorMaterialRegistry.HAUNTBOUND_ARMOR, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC), new SleepyHollowsIdentifier("textures/models/armor/hauntbound_armor_outer_layer.png")));
    public static final RegistrySupplier<Item> HAUNTBOUND_LEGGINGS = ObjectRegistry.registerItem("hauntbound_leggings", () -> new HauntboundLeggingsItem(ArmorMaterialRegistry.HAUNTBOUND_ARMOR, ArmorItem.Type.LEGGINGS, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC), new SleepyHollowsIdentifier("textures/models/armor/hauntbound_armor_inner_layer.png")));
    public static final RegistrySupplier<Item> HAUNTBOUND_BOOTS = ObjectRegistry.registerItem("hauntbound_boots", () -> new HauntboundBootsItem(ArmorMaterialRegistry.HAUNTBOUND_ARMOR, ArmorItem.Type.BOOTS, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC), new SleepyHollowsIdentifier("textures/models/armor/hauntbound_armor_outer_layer.png")));
    public static final RegistrySupplier<Block> COFFIN = ObjectRegistry.registerBlockWithBlockItem("coffin", () -> new CoffinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_278166_(PushReaction.DESTROY)));
    public static final RegistrySupplier<Item> SPECTRAL_ESSENCE = ObjectRegistry.registerItem("spectral_essence", () -> new Item(ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> ESSENCE_OF_UNDEAD = ObjectRegistry.registerItem("essence_of_undead", () -> new Item(ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> LUMINOUS_ESSENCE = ObjectRegistry.registerItem("luminous_essence", () -> new Item(ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> LUMINOUS_WATER = ObjectRegistry.registerItem("luminous_water", () -> new LuminousWaterItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_).m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> LUMINOUS_WATER_SPLASH = ObjectRegistry.registerItem("splash_luminous_water", () -> new Item(ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> DUSK_BERRIES = ObjectRegistry.registerItem("dusk_berries", () -> new DuskBerryItem((Block)DUSKBERRY_BUSH.get(), new Item.Properties().m_41489_(Foods.f_38808_)));
    public static final RegistrySupplier<Item> SPECTRAL_PUMPKIN_PIE = ObjectRegistry.registerItem("spectral_pumpkin_pie", () -> new SpectralPumpkinPieItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38801_).m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> CANDY_CORN = ObjectRegistry.registerItem("candy_corn", () -> new CandyCornItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Item> LOOTBAG = ObjectRegistry.registerItem("lootbag", () -> new LootBagItem(ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> REINS_OF_THE_SPECTRAL_HORSE = ObjectRegistry.registerItem("reins_of_the_spectral_horse", () -> new ReinsOfTheSpectralHorseItem(EntityTypeRegistry.SPECTRAL_HORSE, -1, -1, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> INFECTED_ZOMBIE_SPAWN_EGG = ObjectRegistry.registerItem("infected_zombie_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.INFECTED_ZOMBIE, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> FLEEING_PUMPKIN_HEAD_SPAWN_EGG = ObjectRegistry.registerItem("fleeing_pumpkin_head_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.FLEEING_PUMPKIN_HEAD, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> COMPLETIONIST_BANNER = ObjectRegistry.registerBlockWithBlockItem("completionist_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> COMPLETIONIST_WALL_BANNER = ObjectRegistry.registerBlockWithoutItem("completionist_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Item> RAUBBAU = ObjectRegistry.registerItem("raubbau", () -> new RaubbauItem(ObjectRegistry.getSettings().m_41486_().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> SPECTRAL_WARAXE = ObjectRegistry.registerItem("spectral_waraxe", () -> new SpectralWarAxeItem(ObjectRegistry.getSettings().m_41486_().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> SHATTERBRAND = ObjectRegistry.registerItem("shatterbrand", () -> new ShatterbrandSwordItem(ObjectRegistry.getSettings().m_41486_().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> HORSEMAN_SPAWN_EGG = ObjectRegistry.registerItem("horseman_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.HORSEMAN, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> POTTED_HOLLOW_SAPLING = ObjectRegistry.registerBlockWithoutItem("potted_hollow_sapling", () -> new FlowerPotBlock((Block)HOLLOW_SAPLING.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_GRAVE_LILY = ObjectRegistry.registerBlockWithoutItem("potted_grave_lily", () -> new FlowerPotBlock((Block)GRAVE_LILY.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_DREAMSHADE = ObjectRegistry.registerBlockWithoutItem("potted_dreamshade", () -> new FlowerPotBlock((Block)DREAMSHADE.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_SHADOWBLOOM = ObjectRegistry.registerBlockWithoutItem("potted_shadowbloom", () -> new FlowerPotBlock((Block)SHADOWBLOOM.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));

    public static void init() {
        BLOCKS.register();
        ITEMS.register();
    }

    public static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("sleepy_hollows", name));
    }

    public static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return SleepyHollowsUtil.abstractItemRegistration(ITEMS, ITEM_REGISTRAR, new SleepyHollowsIdentifier(path), itemSupplier);
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockWithoutItem(String path, Supplier<T> block) {
        return SleepyHollowsUtil.abstractBlockWithoutItemRegistration(BLOCKS, BLOCK_REGISTRAR, new SleepyHollowsIdentifier(path), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockWithBlockItem(String name, Supplier<T> block) {
        return SleepyHollowsUtil.abstractBlockItemRegistration(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, new SleepyHollowsIdentifier(name), block);
    }
}

