/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.sleepy_hollows.core.block.custom.entity.CoffinBlockEntity;
import net.satisfy.sleepy_hollows.core.block.custom.entity.CompletionistBannerEntity;
import net.satisfy.sleepy_hollows.core.block.custom.entity.DummyCoffinBlockEntity;
import net.satisfy.sleepy_hollows.core.block.custom.entity.PedestalBlockEntity;
import net.satisfy.sleepy_hollows.core.entity.FleeingPumpkinHead;
import net.satisfy.sleepy_hollows.core.entity.Horseman;
import net.satisfy.sleepy_hollows.core.entity.InfectedZombie;
import net.satisfy.sleepy_hollows.core.entity.SpectralHorse;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"sleepy_hollows", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"sleepy_hollows", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<BlockEntityType<PedestalBlockEntity>> DISPLAY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("display", () -> BlockEntityType.Builder.m_155273_(PedestalBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PEDESTAL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CoffinBlockEntity>> COFFIN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("coffin", () -> BlockEntityType.Builder.m_155273_(CoffinBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COFFIN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> COMPLETIONIST_BANNER_ENTITY = EntityTypeRegistry.registerBlockEntity("completionist_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COMPLETIONIST_BANNER.get(), (Block)ObjectRegistry.COMPLETIONIST_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DummyCoffinBlockEntity>> DUMMY_COFFIN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("dummy_coffin", () -> BlockEntityType.Builder.m_155273_(DummyCoffinBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COFFIN.get()}).m_58966_(null));
    public static final RegistrySupplier<EntityType<SpectralHorse>> SPECTRAL_HORSE = EntityTypeRegistry.registerEntity("spectral_horse", () -> EntityType.Builder.m_20704_(SpectralHorse::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.87f).m_20702_(10).m_20717_(3).m_20712_(new SleepyHollowsIdentifier("spectral_horse").toString()));
    public static final RegistrySupplier<EntityType<InfectedZombie>> INFECTED_ZOMBIE = EntityTypeRegistry.registerEntity("infected_zombie", () -> EntityType.Builder.m_20704_(InfectedZombie::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20712_(new SleepyHollowsIdentifier("infected_zombie").toString()));
    public static final RegistrySupplier<EntityType<FleeingPumpkinHead>> FLEEING_PUMPKIN_HEAD = EntityTypeRegistry.registerEntity("fleeing_pumpkin_head", () -> EntityType.Builder.m_20704_(FleeingPumpkinHead::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20712_(new SleepyHollowsIdentifier("fleeing_pumpkin_head").toString()));
    public static final RegistrySupplier<EntityType<Horseman>> HORSEMAN = EntityTypeRegistry.registerEntity("horseman", () -> EntityType.Builder.m_20704_(Horseman::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.4f, 2.6f).m_20712_(new SleepyHollowsIdentifier("horseman").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new SleepyHollowsIdentifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new SleepyHollowsIdentifier(path), type);
    }

    static void registerAttributes() {
        EntityAttributeRegistry.register(SPECTRAL_HORSE, SpectralHorse::createAttributes);
        EntityAttributeRegistry.register(INFECTED_ZOMBIE, InfectedZombie::createAttributes);
        EntityAttributeRegistry.register(FLEEING_PUMPKIN_HEAD, FleeingPumpkinHead::createAttributes);
        EntityAttributeRegistry.register(HORSEMAN, Horseman::createAttributes);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

