/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.sleepy_hollows.client.model.armor.HauntboundBootsModel;
import net.satisfy.sleepy_hollows.client.model.armor.HauntboundChestplateModel;
import net.satisfy.sleepy_hollows.client.model.armor.HauntboundHelmetModel;
import net.satisfy.sleepy_hollows.client.model.armor.HauntboundLeggingsModel;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundBootsItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundChestplateItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundHelmetItem;
import net.satisfy.sleepy_hollows.core.item.custom.HauntboundLeggingsItem;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.util.SanityManager;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class ArmorRegistry {
    private static final Map<Item, HauntboundHelmetModel<?>> models = new HashMap();
    private static final Map<Item, HauntboundChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<Item, HauntboundLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<Item, HauntboundBootsModel<?>> bootsModels = new HashMap();

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        HauntboundHelmetModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.HAUNTBOUND_HELMET.get()) {
                return new HauntboundHelmetModel(modelSet.m_171103_(HauntboundHelmetModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyHead(baseHead);
        return model;
    }

    public static Model getChestplateModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm) {
        HauntboundChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()) {
                return new HauntboundChestplateModel(Minecraft.m_91087_().m_167973_().m_171103_(HauntboundChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyBody(body, leftArm, rightArm);
        return model;
    }

    public static Model getLeggingsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        HauntboundLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.HAUNTBOUND_LEGGINGS.get()) {
                return new HauntboundLeggingsModel(Minecraft.m_91087_().m_167973_().m_171103_(HauntboundLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyLegs(rightLeg, leftLeg);
        return model;
    }

    public static Model getBootsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        HauntboundBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.HAUNTBOUND_BOOTS.get()) {
                return new HauntboundBootsModel(Minecraft.m_91087_().m_167973_().m_171103_(HauntboundBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyLegs(rightLeg, leftLeg);
        return model;
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        ChatFormatting color;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = player;
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        boolean hasFullSet = helmet.m_41720_() instanceof HauntboundHelmetItem && chestplate.m_41720_() instanceof HauntboundChestplateItem && leggings.m_41720_() instanceof HauntboundLeggingsItem && boots.m_41720_() instanceof HauntboundBootsItem;
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(String.valueOf(ChatFormatting.DARK_GREEN) + I18n.m_118938_((String)"tooltip.sleepy_hollows.armor.hauntbound_armor_0", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet.m_41720_() instanceof HauntboundHelmetItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.HAUNTBOUND_HELMET.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplate.m_41720_() instanceof HauntboundChestplateItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggings.m_41720_() instanceof HauntboundLeggingsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((boots.m_41720_() instanceof HauntboundBootsItem ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.HAUNTBOUND_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        boolean setBonusEnabled = PlatformHelper.isHauntboundSetBonusEnabled();
        ChatFormatting chatFormatting = color = hasFullSet && setBonusEnabled ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        if (setBonusEnabled) {
            tooltip.add(Component.m_130674_((String)(String.valueOf(color) + I18n.m_118938_((String)"tooltip.sleepy_hollows.armor.hauntbound_armor_1", (Object[])new Object[0]))));
            tooltip.add(Component.m_130674_((String)(String.valueOf(color) + I18n.m_118938_((String)"tooltip.sleepy_hollows.armor.hauntbound_armor_2", (Object[])new Object[0]))));
            if (hasFullSet && !SanityManager.isClientImmune(localPlayer)) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.MENTAL_FORTITUDE.get(), 20, 0));
            }
        }
    }
}

