/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.entity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.sleepy_hollows.core.entity.Horseman;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class FleeingPumpkinHead
extends Monster {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.sleepy_hollows.fleeing_pumpkin_head"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private boolean summonedZombiesAndSkeletonsAt75 = false;
    private boolean summonedZombiesAndSkeletonsAt25 = false;
    private boolean isFrozen = false;
    private long frozenUntil = 0L;
    private boolean increasedArmor = false;
    private Horseman summoner;
    private final Map<LivingEntity, Integer> flyingEntities = new HashMap<LivingEntity, Integer>();
    private boolean isFlyingAway = false;
    private int flightDuration;
    private int flightTicks;
    private Vec3 flightStartPos;
    private Vec3 flightEndPos;
    private double flightArcHeight;

    public FleeingPumpkinHead(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.m_6593_((Component)Component.m_237115_((String)"entity.sleepy_hollows.fleeing_pumpkin_head"));
        this.m_20340_(true);
        this.f_21345_.m_25352_(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidPlayerGoal(this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, PlatformHelper.getFleeingPumpkinMovementSpeed()).m_22268_(Attributes.f_22276_, PlatformHelper.getFleeingPumpkinMaxHealth()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22284_, PlatformHelper.getFleeingPumpkinArmor());
    }

    public void setSummoner(Horseman summoner) {
        this.summoner = summoner;
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.isMoving()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        Iterator<Map.Entry<LivingEntity, Integer>> iterator = this.flyingEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LivingEntity, Integer> entry = iterator.next();
            LivingEntity entity = entry.getKey();
            int remainingTicks = entry.getValue();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 0.0, 0.0, 0.0);
            Vec3 position = entity.m_20182_();
            BlockPos currentPos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
            if (!this.m_9236_().m_8055_(currentPos).m_60795_()) {
                entity.m_20242_(false);
                iterator.remove();
                continue;
            }
            if (--remainingTicks <= 0) {
                entity.m_20242_(false);
                iterator.remove();
                continue;
            }
            entry.setValue(remainingTicks);
        }
        if (this.isFlyingAway) {
            double t = (double)this.flightTicks / (double)this.flightDuration;
            if (t >= 1.0) {
                this.isFlyingAway = false;
                this.f_19794_ = false;
            } else {
                double x = this.flightStartPos.f_82479_ + (this.flightEndPos.f_82479_ - this.flightStartPos.f_82479_) * t;
                double z = this.flightStartPos.f_82481_ + (this.flightEndPos.f_82481_ - this.flightStartPos.f_82481_) * t;
                double y = this.flightStartPos.f_82480_ + this.flightArcHeight * Math.sin(Math.PI * t);
                Vec3 newPos = new Vec3(x, y, z);
                BlockPos currentPos = new BlockPos((int)Math.floor(newPos.f_82479_), (int)Math.floor(newPos.f_82480_), (int)Math.floor(newPos.f_82481_));
                if (!this.m_9236_().m_8055_(currentPos).m_60795_()) {
                    this.isFlyingAway = false;
                    this.f_19794_ = false;
                    return;
                }
                if (!this.isPositionSafe(newPos)) {
                    this.isFlyingAway = false;
                    this.f_19794_ = false;
                    return;
                }
                this.m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                this.f_19859_ = this.m_146908_();
                this.m_146922_(this.m_146908_() + 10.0f);
                this.f_20885_ = this.m_146908_();
                this.f_20883_ = this.m_146908_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
                ++this.flightTicks;
            }
        } else {
            if (this.summoner != null && this.summoner.m_6084_()) {
                double distanceSq = this.m_20280_((Entity)this.summoner);
                if (distanceSq > 5625.0) {
                    this.m_21573_().m_5624_((Entity)this.summoner, 1.0);
                }
            } else {
                this.summoner = null;
            }
            if (this.isFrozen && this.m_9236_().m_46467_() >= this.frozenUntil) {
                this.isFrozen = false;
            }
            if (this.isFrozen) {
                this.m_20256_(Vec3.f_82478_);
                this.applyTremblingEffect();
            }
            if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.75 && !this.summonedZombiesAndSkeletonsAt75) {
                this.summonZombiesAndSkeletons();
                this.summonedZombiesAndSkeletonsAt75 = true;
            }
            if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.25 && !this.summonedZombiesAndSkeletonsAt25) {
                this.summonZombiesAndSkeletons();
                this.summonedZombiesAndSkeletonsAt25 = true;
            }
            if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.5 && !this.increasedArmor) {
                this.increaseArmorByTenPercent();
                this.increasedArmor = true;
            }
        }
    }

    private boolean canSpawnEntityAt(BlockPos pos) {
        return this.m_9236_().m_46859_(pos) && this.m_9236_().m_46859_(pos.m_7494_());
    }

    private boolean isPositionSafe(Vec3 pos) {
        BlockPos blockPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_), (int)Math.floor(pos.f_82481_));
        return this.m_9236_().m_46859_(blockPos) && this.m_9236_().m_46859_(blockPos.m_7494_());
    }

    private void increaseArmorByTenPercent() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22115_() * 1.1);
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    private void applyTremblingEffect() {
        double trembleAmount = 0.05;
        double trembleX = (Math.random() - 0.5) * trembleAmount;
        double trembleZ = (Math.random() - 0.5) * trembleAmount;
        this.m_6034_(this.m_20185_() + trembleX, this.m_20186_(), this.m_20189_() + trembleZ);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.isFlyingAway) {
            return false;
        }
        boolean damaged = super.m_6469_(source, amount);
        if (damaged) {
            this.freezeFor();
        }
        return damaged;
    }

    private void freezeFor() {
        this.isFrozen = true;
        this.frozenUntil = this.m_9236_().m_46467_() + 10L;
    }

    private void summonZombiesAndSkeletons() {
        double vy;
        double vz;
        double vx;
        double angle;
        double speed;
        BlockPos spawnPos;
        int i;
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEventRegistry.FLEEING_PUMPKIN_SUMMONING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        for (Player player : this.m_9236_().m_6907_()) {
            ServerPlayer serverPlayer;
            if (!(player instanceof ServerPlayer) || !(serverPlayer = (ServerPlayer)player).m_142582_((Entity)this) || !(serverPlayer.m_20270_((Entity)this) <= 10.0f)) continue;
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 3));
        }
        for (i = 0; i < 5; ++i) {
            Zombie zombie;
            spawnPos = this.m_20183_().m_7918_(this.f_19796_.m_188503_(5) - 2, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(5) - 2);
            if (!this.canSpawnEntityAt(spawnPos) || (zombie = (Zombie)((EntityType)EntityTypeRegistry.INFECTED_ZOMBIE.get()).m_20615_(this.m_9236_())) == null) continue;
            zombie.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            speed = 0.3;
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            vx = Math.cos(angle) * speed;
            vz = Math.sin(angle) * speed;
            vy = this.f_19796_.m_188500_() * 0.125 + 0.125;
            zombie.m_20256_(new Vec3(vx, vy, vz));
            zombie.m_20242_(true);
            this.flyingEntities.put((LivingEntity)zombie, 20);
            zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ObjectRegistry.SPECTRAL_JACK_O_LANTERN.get()));
            zombie.m_21409_(EquipmentSlot.HEAD, 0.1f);
            zombie.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            zombie.m_21409_(EquipmentSlot.CHEST, 0.01f);
            zombie.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            zombie.m_21409_(EquipmentSlot.LEGS, 0.01f);
            zombie.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            zombie.m_21409_(EquipmentSlot.FEET, 0.01f);
            ItemStack enchantedSword = new ItemStack((ItemLike)ObjectRegistry.SPECTRAL_WARAXE.get());
            enchantedSword.m_41663_(Enchantments.f_44977_, 3);
            enchantedSword.m_41663_(Enchantments.f_44981_, 1);
            zombie.m_8061_(EquipmentSlot.MAINHAND, enchantedSword);
            zombie.m_21409_(EquipmentSlot.MAINHAND, 0.03f);
            if (zombie.m_21051_(Attributes.f_22284_) != null) {
                double currentArmor = Objects.requireNonNull(zombie.m_21051_(Attributes.f_22284_)).m_22115_();
                Objects.requireNonNull(zombie.m_21051_(Attributes.f_22284_)).m_22100_(Math.max(0.0, currentArmor - 8.0));
            }
            zombie.m_6593_((Component)Component.m_237115_((String)"entity.sleepy_hollows.hauntbound_zombie"));
            zombie.m_20340_(false);
            this.m_9236_().m_7967_((Entity)zombie);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, zombie.m_20185_(), zombie.m_20186_() + 0.5, zombie.m_20189_(), 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 2; ++i) {
            Skeleton skeleton;
            spawnPos = this.m_20183_().m_7918_(this.f_19796_.m_188503_(5) - 2, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(5) - 2);
            if (!this.canSpawnEntityAt(spawnPos) || (skeleton = (Skeleton)EntityType.f_20524_.m_20615_(this.m_9236_())) == null) continue;
            skeleton.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            speed = 0.3;
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            vx = Math.cos(angle) * speed;
            vz = Math.sin(angle) * speed;
            vy = this.f_19796_.m_188500_() * 0.125 + 0.125;
            skeleton.m_20256_(new Vec3(vx, vy, vz));
            skeleton.m_20242_(true);
            this.flyingEntities.put((LivingEntity)skeleton, 20);
            skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ObjectRegistry.SPECTRAL_JACK_O_LANTERN.get()));
            skeleton.m_21409_(EquipmentSlot.HEAD, 0.1f);
            skeleton.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            skeleton.m_21409_(EquipmentSlot.CHEST, 0.01f);
            skeleton.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            skeleton.m_21409_(EquipmentSlot.LEGS, 0.01f);
            skeleton.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            skeleton.m_21409_(EquipmentSlot.FEET, 0.01f);
            ItemStack enchantedBow = new ItemStack((ItemLike)Items.f_42411_);
            enchantedBow.m_41663_(Enchantments.f_44988_, 10);
            skeleton.m_8061_(EquipmentSlot.MAINHAND, enchantedBow);
            skeleton.m_21409_(EquipmentSlot.MAINHAND, 0.01f);
            skeleton.m_6593_((Component)Component.m_237115_((String)"entity.sleepy_hollows.hauntbound_marksman"));
            skeleton.m_20340_(false);
            this.m_9236_().m_7967_((Entity)skeleton);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, skeleton.m_20185_(), skeleton.m_20186_() + 0.5, skeleton.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void startFlyingAway() {
        this.isFlyingAway = true;
        this.flightDuration = 60;
        this.flightTicks = 0;
        this.flightStartPos = this.m_20182_();
        double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
        double distance = 15.0;
        double dx = Math.cos(angle) * distance;
        double dz = Math.sin(angle) * distance;
        this.flightEndPos = this.flightStartPos.m_82520_(dx, 0.0, dz);
        this.flightArcHeight = 5.0;
        this.f_19794_ = true;
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12016_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        this.bossEvent.m_7706_();
        this.spawnFlashParticles();
    }

    private void spawnFlashParticles() {
        for (int i = 0; i < 60; ++i) {
            double xOffset = (Math.random() - 0.5) * 2.0;
            double yOffset = Math.random() * 2.0;
            double zOffset = (Math.random() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventRegistry.FLEEING_PUMPKIN_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.FLEEING_PUMPKIN_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundEventRegistry.FLEEING_PUMPKIN_AMBIENT.get();
    }

    public boolean m_6149_() {
        return false;
    }

    public static class AvoidPlayerGoal
    extends Goal {
        private final FleeingPumpkinHead entity;
        private final double speed;

        public AvoidPlayerGoal(FleeingPumpkinHead entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Player nearestPlayer = this.entity.m_9236_().m_45930_((Entity)this.entity, 10.0);
            return nearestPlayer != null && !this.entity.isFrozen;
        }

        public void m_8056_() {
            Player nearestPlayer = this.entity.m_9236_().m_45930_((Entity)this.entity, 10.0);
            if (nearestPlayer != null) {
                Vec3 awayVector = this.entity.m_20182_().m_82546_(nearestPlayer.m_20182_()).m_82541_();
                Vec3 targetPos = this.entity.m_20182_().m_82549_(awayVector.m_82490_(10.0));
                if (this.entity.isPositionSafe(targetPos)) {
                    this.entity.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.speed);
                } else {
                    this.entity.m_21573_().m_26519_(this.entity.m_20185_() + awayVector.f_82479_ * 5.0, this.entity.m_20186_(), this.entity.m_20189_() + awayVector.f_82481_ * 5.0, this.speed);
                }
            }
        }

        public boolean m_8045_() {
            Player nearestPlayer = this.entity.m_9236_().m_45930_((Entity)this.entity, 10.0);
            return nearestPlayer != null && !this.entity.isFrozen;
        }
    }
}

