/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.sleepy_hollows.core.block.custom.CoffinBlock;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;

public class CoffinBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController = new ChestLidController();

    public CoffinBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.COFFIN_BLOCK_ENTITY.get(), blockPos, blockState);
        this.items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                CoffinBlockEntity.this.playOpenSound(blockState);
            }

            protected void m_142289_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                CoffinBlockEntity.this.playCloseSound(blockState);
            }

            protected void m_142148_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, int i, int j) {
                CoffinBlockEntity.this.signalOpenCount(level, blockPos, blockState, i, j);
            }

            protected boolean m_142718_(@NotNull Player player) {
                if (player.f_36096_ instanceof ChestMenu) {
                    Container container = ((ChestMenu)player.f_36096_).m_39261_();
                    return container == CoffinBlockEntity.this;
                }
                return false;
            }
        };
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int syncId, @NotNull Inventory playerInventory) {
        return new ChestMenu(MenuType.f_39962_, syncId, playerInventory, (Container)this, 6);
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public int m_6643_() {
        return 54;
    }

    public void m_5856_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    void playOpenSound(BlockState blockState) {
        Vec3i vec3i = ((Direction)blockState.m_61143_((Property)CoffinBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, (SoundEvent)SoundEventRegistry.COFFIN_OPEN.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_());
    }

    void playCloseSound(BlockState blockState) {
        Vec3i vec3i = ((Direction)blockState.m_61143_((Property)CoffinBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, (SoundEvent)SoundEventRegistry.COFFIN_CLOSE.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_());
    }

    public float m_6683_(float f) {
        return this.chestLidController.m_155375_(f);
    }

    public static void lidAnimateTick(Level level, BlockPos blockPos, BlockState blockState, CoffinBlockEntity cofferBlockEntity) {
        cofferBlockEntity.chestLidController.m_155374_();
    }

    public boolean m_7531_(int i, int j) {
        if (i == 1) {
            this.chestLidController.m_155377_(j > 0);
            return true;
        }
        return super.m_7531_(i, j);
    }

    protected void signalOpenCount(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
        Block block = blockState.m_60734_();
        level.m_7696_(blockPos, block, 1, j);
    }
}

