/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsUtil;
import org.jetbrains.annotations.NotNull;

public class TombstoneBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private final VoxelShape shape;

    public TombstoneBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)ACTIVE) != false ? 10 : 0));
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!world.f_46443_) {
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                this.spawnSkeletonsAndParticles(world, pos);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            } else if (player.m_21120_(hand).m_41720_() == ObjectRegistry.SPECTRAL_ESSENCE.get()) {
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                world.m_5594_(null, pos, SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnParticles(world, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void spawnSkeletonsAndParticles(Level world, BlockPos pos) {
        BlockPos[] spawnPositions = new BlockPos[]{pos.m_7918_(2, 0, 0), pos.m_7918_(-2, 0, 0), pos.m_7918_(0, 0, -2)};
        Random random = new Random();
        ItemStack[] armorPieces = new ItemStack[]{new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()), new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()), new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_BOOTS.get()), new ItemStack((ItemLike)Items.f_42740_)};
        EquipmentSlot[] armorSlots = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.OFFHAND};
        for (int i = 0; i < spawnPositions.length; ++i) {
            BlockPos spawnPos = spawnPositions[i];
            Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(world);
            if (skeleton != null) {
                skeleton.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)(spawnPos.m_123342_() + 1), (double)spawnPos.m_123343_() + 0.5);
                skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ObjectRegistry.SPECTRAL_JACK_O_LANTERN.get()));
                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ObjectRegistry.SPECTRAL_WARAXE.get()));
                for (int j = 0; j < armorPieces.length; ++j) {
                    if (!((double)random.nextFloat() < 0.3)) continue;
                    skeleton.m_8061_(armorSlots[j], armorPieces[j]);
                }
                world.m_7967_((Entity)skeleton);
            }
            this.spawnParticles(world, spawnPos);
            if (world.f_46443_) continue;
            world.m_186460_(pos, (Block)this, i * 10);
            world.m_5594_(null, spawnPos, SoundEvents.f_215750_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (!world.f_46443_) {
            ItemStack dropItem = new ItemStack((ItemLike)ObjectRegistry.ESSENCE_OF_UNDEAD.get());
            TombstoneBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropItem);
        }
    }

    private void spawnParticles(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.05);
        }
    }

    public void m_6256_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.spawnSkeletonsAndParticles(world, pos);
            if (!player.m_6673_(world.m_269111_().m_269425_())) {
                player.m_6469_(world.m_269111_().m_269425_(), 5.0f);
            }
        }
    }

    public static VoxelShape createSmallTombstoneShape() {
        return Shapes.m_83048_((double)0.125, (double)0.0, (double)0.375, (double)0.875, (double)1.0, (double)0.625);
    }

    public static VoxelShape createMidTombstoneShape() {
        VoxelShape bottom = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.25, (double)0.75);
        VoxelShape top = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
        return Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)top);
    }

    public static VoxelShape createWoodenTombstoneShape() {
        VoxelShape bottom = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
        VoxelShape top = Shapes.m_83048_((double)0.375, (double)0.25, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
        return Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)top);
    }

    public static VoxelShape createBigTombstoneShapeBottom() {
        VoxelShape bottom = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.25, (double)0.75);
        VoxelShape top = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
        return Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)top);
    }

    public static VoxelShape createBigTombstoneShapeTop() {
        VoxelShape bottom = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)0.125, (double)0.625);
        VoxelShape top = Shapes.m_83048_((double)0.125, (double)0.125, (double)0.375, (double)0.875, (double)0.25, (double)0.625);
        return Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)top);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SleepyHollowsUtil.rotateShape(Direction.NORTH, facing, this.shape);
    }
}

