/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.sleepy_hollows.core.block.custom.CoffinBlock;
import net.satisfy.sleepy_hollows.core.block.custom.entity.CoffinBlockEntity;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class CoffinRenderer
implements BlockEntityRenderer<CoffinBlockEntity> {
    private static final ResourceLocation TEXTURE = new SleepyHollowsIdentifier("textures/entity/coffin.png");
    private final ModelPart coffin;
    private final ModelPart lid;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new SleepyHollowsIdentifier("coffin"), "main");

    public CoffinRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(LAYER_LOCATION);
        this.coffin = modelPart.m_171324_("coffin");
        this.lid = this.coffin.m_171324_("lid");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition coffin = partdefinition.m_171599_("coffin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-16.0f, -10.0f, 0.0f, 16.0f, 10.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition lid = coffin.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-16.0f, 1.5f, -16.0f, 16.0f, 4.0f, 32.0f, new CubeDeformation(0.0f)).m_171514_(0, 78).m_171488_(-14.0f, -0.5f, -16.0f, 12.0f, 2.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.0f, (float)-15.5f, (float)16.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void render(CoffinBlockEntity blockEntity, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.m_58900_().m_61143_(CoffinBlock.BED_PART) != BedPart.HEAD) {
            return;
        }
        float lidAngle = blockEntity.m_6683_(partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - (float)Math.pow(lidAngle, 1.0);
        float slideDistance = lidAngle * 8.0f;
        this.lid.f_104200_ = -slideDistance;
        poseStack.m_85836_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)CoffinBlock.FACING);
        switch (facing) {
            case NORTH: {
                poseStack.m_85837_(1.0, 1.0, 0.0);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.0, 1.0, 1.0);
                break;
            }
            case EAST: {
                poseStack.m_85837_(1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.0, 1.0, 0.0);
            }
        }
        poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-facing.m_122435_() + 180.0f)));
        poseStack.m_252781_(new Quaternionf().rotateX((float)Math.toRadians(180.0)));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.coffin.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

