/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.item.tool.AxeItemHooks;
import dev.architectury.platform.Platform;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.satisfy.sleepy_hollows.Constants;
import net.satisfy.sleepy_hollows.client.event.HUDRenderEvent;
import net.satisfy.sleepy_hollows.core.event.ArmorEffectHandler;
import net.satisfy.sleepy_hollows.core.network.SleepyHollowsNetwork;
import net.satisfy.sleepy_hollows.core.network.message.SanityPacketMessage;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.FeatureTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.FlammableBlockRegistry;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.core.registry.TabRegistry;
import net.satisfy.sleepy_hollows.core.registry.TagRegistry;
import net.satisfy.sleepy_hollows.core.util.SanityManager;
import net.satisfy.sleepy_hollows.core.world.SleepyHollowsBiomeKeys;

public final class SleepyHollows {
    public static void init() {
        ObjectRegistry.init();
        TabRegistry.init();
        MobEffectRegistry.init();
        EntityTypeRegistry.init();
        SoundEventRegistry.init();
        FeatureTypeRegistry.init();
        SleepyHollowsNetwork.init();
        ArmorEffectHandler.init();
        Constants.LOG.info("Sleepy Hollows has been initialized in the common setup phase.");
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientGuiEvent.RENDER_HUD.register(HUDRenderEvent::onRenderHUD);
        }
    }

    public static void commonInit() {
        FlammableBlockRegistry.init();
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.HOLLOW_LOG.get()), (Block)((Block)ObjectRegistry.STRIPPED_HOLLOW_LOG.get()));
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.HOLLOW_WOOD.get()), (Block)((Block)ObjectRegistry.STRIPPED_HOLLOW_WOOD.get()));
    }

    public static void onServerTick(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (SanityManager.getSanity(player) <= 0 && player.f_8941_.m_9294_()) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.INSANITY.get(), 1200));
                SanityManager.changeSanity(player, 100);
                SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(100));
            }
            if (server.m_129921_() % 20 == 0) {
                SanityManager.doBlockCheck(player);
            }
            if (server.m_129921_() % 100 != 0) continue;
            if (SanityManager.isImmune(player) || player.m_9236_().m_8055_(player.m_20183_()).m_204336_(TagRegistry.RESET_SANITY)) {
                return;
            }
            if (!player.m_9236_().m_204166_(player.m_20097_()).m_203565_(SleepyHollowsBiomeKeys.SLEEPY_HOLLOWS)) {
                SanityManager.changeSanity(player, SanityManager.Modifiers.OUTSIDE_BIOME.getValue());
                SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(SanityManager.Modifiers.OUTSIDE_BIOME.getValue()));
                continue;
            }
            SanityManager.changeSanity(player, SanityManager.Modifiers.INSIDE_BIOME.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(SanityManager.Modifiers.INSIDE_BIOME.getValue()));
        }
    }
}

