/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.Constants;
import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BloodMoonEvent
extends LunarEvent {
    private static final ResourceLocation MOON_TEXTURE = Constants.modLoc("textures/environment/blood.png");
    private static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("2f00d1d5-a4aa-4c2f-bb48-1d6570507666");
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("267db29a-2a6f-4c9d-b3c8-512c085bdf21");

    public BloodMoonEvent() {
        super(Constants.modLoc("blood_moon"), 0x882E2E);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getBloodMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.blood_moon";
    }

    @Override
    public boolean applySpawnEffect() {
        return true;
    }

    @Override
    public void applySpawnEffect(LivingEntity livingEntity, MobSpawnType spawnType) {
        if (spawnType == MobSpawnType.NATURAL) {
            AttributeInstance healthAttribute;
            float difficultyMultiplier = livingEntity.m_9236_().m_6436_(livingEntity.m_20183_()).m_19057_();
            RandomSource random = livingEntity.m_217043_();
            AttributeInstance attackAttribute = livingEntity.m_21051_(Attributes.f_22281_);
            if (attackAttribute != null) {
                int damageBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = damageBoost = i > 0 ? random.m_188503_(i) : 0;
                }
                if (damageBoost > 0) {
                    attackAttribute.m_22125_(new AttributeModifier(DAMAGE_MODIFIER_UUID, "Blood moon damage boost", (double)damageBoost, AttributeModifier.Operation.ADDITION));
                }
            }
            if ((healthAttribute = livingEntity.m_21051_(Attributes.f_22276_)) != null) {
                int healthBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = healthBoost = i > 0 ? random.m_188503_(i) : 0;
                }
                if (healthBoost > 0) {
                    healthAttribute.m_22125_(new AttributeModifier(HEALTH_MODIFIER_UUID, "Blood moon health boost", (double)healthBoost, AttributeModifier.Operation.ADDITION));
                }
            }
        }
    }

    @Override
    public void stopEffects(Level level) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                AttributeInstance healthAttribute;
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6084_()) continue;
                AttributeInstance attackAttribute = livingEntity.m_21051_(Attributes.f_22281_);
                if (attackAttribute != null) {
                    attackAttribute.m_22127_(DAMAGE_MODIFIER_UUID);
                }
                if ((healthAttribute = livingEntity.m_21051_(Attributes.f_22276_)) == null) continue;
                healthAttribute.m_22127_(HEALTH_MODIFIER_UUID);
            }
        }
    }

    @Override
    public ResourceLocation moonTexture() {
        return MOON_TEXTURE;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        if (!Services.PLATFORM.canSleepIn(this.getID())) {
            return EventResult.DENY;
        }
        return EventResult.DEFAULT;
    }
}

