/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class LunarCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"lunar");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"forceEvent").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"eventID", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(LunarRegistry.instance().getIDList(), (SuggestionsBuilder)builder)).executes(ctx -> LunarCommands.forceEvent((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82129_((String)"forceCurrent", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> LunarCommands.forceEvent((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"forceCurrent"))))));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"skip").executes(LunarCommands::skipEvent));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"randomize").executes(LunarCommands::randomizeEvent));
        dispatcher.register(root);
    }

    private static int forceEvent(CommandContext<CommandSourceStack> ctx, boolean forceCurrent) {
        ResourceLocation eventID = ResourceLocationArgument.m_107011_(ctx, (String)"eventID");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129880_(Level.f_46428_);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        ILunarEvent event = LunarRegistry.instance().getEventByID(eventID);
        if (event == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No lunar event found with ID: " + String.valueOf(eventID))));
            return 0;
        }
        if (forceCurrent) {
            phaseData.getActiveLunarEvent().stopEffects((Level)level);
            phaseData.setActiveEvent(event);
            phaseData.syncEvent((Level)level);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully forced a " + Component.m_237115_((String)event.getTranslationKey()).getString() + " moon")), true);
        } else {
            phaseData.setForcedEvent(event);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully forced a " + Component.m_237115_((String)event.getTranslationKey()).getString() + " moon next night")), true);
        }
        return 0;
    }

    private static int skipEvent(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129880_(Level.f_46428_);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        phaseData.getActiveLunarEvent().stopEffects((Level)level);
        phaseData.setDefaultMoon();
        phaseData.syncEvent((Level)level);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Successfully skipped the lunar event for tonight"), true);
        return 0;
    }

    private static int randomizeEvent(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129880_(Level.f_46428_);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        phaseData.getActiveLunarEvent().stopEffects((Level)level);
        phaseData.setRandomLunarEvent((Level)level);
        phaseData.syncEvent((Level)level);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Successfully randomized the lunar event for tonight"), true);
        return 0;
    }
}

