/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MoonHandler {
    private static String moonID = null;
    private static int rawMoonColor = 0xFFFFFF;
    private static float[] moonColor = null;
    private static float rawMoonScale = 1.0f;
    private static Matrix4f moonScale;
    private static ResourceLocation moonTexture;

    public static void colorTheMoon(ClientLevel level, PoseStack poseStack, Matrix4f matrix4f, float partialTick, Camera camera) {
        if (MoonHandler.isEventActive()) {
            RenderSystem.setShaderColor((float)moonColor[0], (float)moonColor[1], (float)moonColor[2], (float)1.0f);
        }
    }

    public static void setMoon(String eventID, int color, float scale) {
        rawMoonColor = color;
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        moonColor = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        moonID = eventID;
        if (scale != 1.0f) {
            moonScale = new Matrix4f().scale(scale, 1.0f, scale);
            rawMoonScale = scale;
        }
    }

    public static void setMoonTexture(@Nullable ResourceLocation location) {
        moonTexture = location;
    }

    public static void disableMoon() {
        moonColor = null;
        moonID = null;
        moonScale = null;
        moonTexture = null;
    }

    public static boolean isEventActive() {
        return moonID != null && moonColor != null;
    }

    public static boolean isMoonScaled() {
        return moonScale != null;
    }

    public static ResourceLocation getMoonTexture(ResourceLocation defaultTexture) {
        if (moonTexture != null) {
            return moonTexture;
        }
        return defaultTexture;
    }

    public static Matrix4f getMoonScale() {
        return moonScale;
    }

    public static Matrix4f scaleMoon(Matrix4f matrix) {
        if (MoonHandler.isMoonScaled() && moonScale != null) {
            matrix.mul((Matrix4fc)moonScale);
        }
        return matrix;
    }

    public static int getMoonColor() {
        return rawMoonColor;
    }

    public static float getRawMoonScale() {
        return rawMoonScale;
    }
}

