/*
 * Decompiled with CFR 0.152.
 */
package me.talilon.minecraft.crawlondemand.capabilities;

import com.mojang.logging.LogUtils;
import me.talilon.minecraft.crawlondemand.capabilities.IPlayerCrawlCapability;
import me.talilon.minecraft.crawlondemand.capabilities.PlayerCrawlCapability;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="crawlondemand", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityHandler {
    public static final Capability<IPlayerCrawlCapability> CRAWL_CAPABILITY;
    private static final Logger LOGGER;
    public static ResourceLocation ID;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            try {
                event.addCapability(ID, (ICapabilityProvider)new PlayerCrawlCapability());
                event.addListener(() -> entity.getCapability(CRAWL_CAPABILITY).invalidate());
                LOGGER.debug("Attached crawl capability to player");
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach crawl capability to Player", (Throwable)e);
            }
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
        CRAWL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerCrawlCapability>(){});
        ID = new ResourceLocation("crawlondemand", "crawling");
    }
}

