/*
 * Decompiled with CFR 0.152.
 */
package me.talilon.minecraft.crawlondemand;

import com.mojang.logging.LogUtils;
import me.talilon.minecraft.crawlondemand.CrawlOnDemand;
import me.talilon.minecraft.crawlondemand.capabilities.CapabilityHandler;
import me.talilon.minecraft.crawlondemand.networking.PoseChangePacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

public class ClientCrawlOnDemand {
    public static final KeyMapping toggleCrawl = new KeyMapping("key.crawlondemand.toggle_crawl", 342, "key.categories.movement");
    public static final KeyMapping crawl = new KeyMapping("key.crawlondemand.crawl", 90, "key.categories.movement");
    private Player player;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEBOUNCE_TIME = 20;
    private long lastClickTime = 0L;

    public ClientCrawlOnDemand() {
        LOGGER.debug("Loading");
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeys);
    }

    @SubscribeEvent
    public void onRegisterKeys(RegisterKeyMappingsEvent event) {
        event.register(toggleCrawl);
        event.register(crawl);
    }

    @SubscribeEvent
    public void keyInput(InputEvent.Key event) {
        this.handleInput(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton event) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastClickTime > 20L) {
            this.handleInput(event.getButton(), event.getAction());
        }
        this.lastClickTime = currentTime;
    }

    private void handleInput(int key, int action) {
        if (key == toggleCrawl.getKey().m_84873_() && action == 1 && toggleCrawl.m_90859_()) {
            LOGGER.debug("Toggle crawl input key press");
            this.ensureFreshPlayer();
            ClientCrawlOnDemand.toggleCrawl(this.player);
        }
        if (key == crawl.getKey().m_84873_()) {
            LOGGER.debug("Crawl input key press");
            this.ensureFreshPlayer();
            ClientCrawlOnDemand.crawl(this.player, action);
        }
    }

    private void ensureFreshPlayer() {
        this.player = Minecraft.m_91087_().f_91074_;
        LOGGER.debug("Player is fresh: {}", (Object)this.player);
    }

    private static void toggleCrawl(Player player) {
        if (player == null) {
            return;
        }
        player.getCapability(CapabilityHandler.CRAWL_CAPABILITY).ifPresent(c -> {
            if (c.getIsCrawling() || player.m_20096_()) {
                c.toggleIsCrawling();
                CrawlOnDemand.INSTANCE.sendToServer((Object)new PoseChangePacket(c.getIsCrawling()));
            }
        });
    }

    private static void crawl(Player player, int action) {
        if (player == null) {
            return;
        }
        player.getCapability(CapabilityHandler.CRAWL_CAPABILITY).ifPresent(c -> {
            if (action == 1 && player.m_20096_()) {
                c.setIsCrawling(true);
                CrawlOnDemand.INSTANCE.sendToServer((Object)new PoseChangePacket(true));
            } else if (action == 0) {
                c.setIsCrawling(false);
                CrawlOnDemand.INSTANCE.sendToServer((Object)new PoseChangePacket(false));
            }
        });
    }
}

